/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.analyze;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.analyze.ValidateExpressionVisitor;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.node.ASTVisitor;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ValidateExpressionVisitorTest {
    @Test
    public void functionReturningNonBooleanShouldTriggerError() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Mockito.when((Object)variableFinder.returnTypeOf("today", new ValueType[0])).thenReturn((Object)ValueType.DATE);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"today()");
        ValidateExpressionVisitor validateExpressionVisitor = new ValidateExpressionVisitor();
        expression.accept((ASTVisitor)validateExpressionVisitor);
        Assertions.assertTrue((boolean)validateExpressionVisitor.hasErrors());
        ((VariableFinder)Mockito.verify((Object)variableFinder, (VerificationMode)Mockito.times((int)2))).isAsync("today");
        ((VariableFinder)Mockito.verify((Object)variableFinder)).returnTypeOf("today", new ValueType[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder});
    }

    @Test
    public void functionReturningBooleanIsAccepted() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Mockito.when((Object)variableFinder.returnTypeOf("booleanFunction", new ValueType[0])).thenReturn((Object)ValueType.BOOLEAN);
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)"booleanFunction()");
        ValidateExpressionVisitor validateExpressionVisitor = new ValidateExpressionVisitor();
        expression.accept((ASTVisitor)validateExpressionVisitor);
        Assertions.assertFalse((boolean)validateExpressionVisitor.hasErrors());
        ((VariableFinder)Mockito.verify((Object)variableFinder, (VerificationMode)Mockito.times((int)2))).isAsync("booleanFunction");
        ((VariableFinder)Mockito.verify((Object)variableFinder)).returnTypeOf("booleanFunction", new ValueType[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder});
    }
}

