/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.DialobRuleParser;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.api.VariableNotDefinedException;
import io.dialob.rule.parser.node.ASTBuilderWalker;
import io.dialob.rule.parser.node.ErrorLogger;
import io.dialob.rule.parser.node.Span;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ASTBuilderWalkerTest {
    @Test
    public void shouldLogUnknownVariableAndIdWhenVariableIsNotFound() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        ErrorLogger errorLogger = (ErrorLogger)Mockito.mock(ErrorLogger.class);
        DialobRuleParser.IdExprRuleContext ctx = (DialobRuleParser.IdExprRuleContext)Mockito.mock(DialobRuleParser.IdExprRuleContext.class);
        ctx.var = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)ctx.var.getText()).thenReturn((Object)"x");
        Mockito.when((Object)ctx.var.getStartIndex()).thenReturn((Object)0);
        Mockito.when((Object)ctx.var.getStopIndex()).thenReturn((Object)1);
        Mockito.when((Object)variableFinder.mapAlias("x")).thenReturn((Object)"x");
        Mockito.when((Object)variableFinder.typeOf("x")).thenThrow(new Throwable[]{new VariableNotDefinedException("x")});
        ASTBuilderWalker astBuilderWalker = new ASTBuilderWalker(variableFinder, (Map)Maps.newHashMap());
        astBuilderWalker.setErrorLogger(errorLogger);
        astBuilderWalker.enterIdExprRule(ctx);
        ((VariableFinder)Mockito.verify((Object)variableFinder)).mapAlias("x");
        ((VariableFinder)Mockito.verify((Object)variableFinder)).typeOf("x");
        ((Token)Mockito.verify((Object)ctx.var, (VerificationMode)Mockito.atLeastOnce())).getStartIndex();
        ((Token)Mockito.verify((Object)ctx.var, (VerificationMode)Mockito.atLeastOnce())).getStopIndex();
        ((Token)Mockito.verify((Object)ctx.var)).getText();
        ((ErrorLogger)Mockito.verify((Object)errorLogger)).logError("UNKNOWN_VARIABLE", new Object[]{"x"}, Span.of((int)0, (int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder, ctx, ctx.var, errorLogger});
    }
}

