/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.service;

import io.dialob.rule.parser.api.RuleExpressionCompiler;
import io.dialob.rule.parser.api.RuleExpressionCompilerCallback;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public abstract class AbstractRuleExpressionCompilerTest {
    private RuleExpressionCompiler compiler;
    @Mock
    private VariableFinder variableFinder;
    @Mock
    private RuleExpressionCompilerCallback callback;

    protected abstract RuleExpressionCompiler createRuleExpressionCompiler();

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.compiler = this.createRuleExpressionCompiler();
        Mockito.when((Object)this.variableFinder.mapAlias(Mockito.anyString())).thenAnswer(answer -> answer.getArguments()[0]);
    }

    @Test
    public void missingArgumentThrowsNullPointerException() {
        Assertions.assertThatThrownBy(() -> this.compiler.compile("x", null, null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> this.compiler.compile("x", (VariableFinder)Mockito.mock(VariableFinder.class), null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> this.compiler.compile("x", null, (RuleExpressionCompilerCallback)Mockito.mock(RuleExpressionCompilerCallback.class))).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> this.compiler.compile(null, (VariableFinder)Mockito.mock(VariableFinder.class), (RuleExpressionCompilerCallback)Mockito.mock(RuleExpressionCompilerCallback.class))).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void shouldNotAcceptIncompleteExpressions() throws Exception {
        Mockito.when((Object)this.variableFinder.typeOf("a")).thenReturn((Object)ValueType.TIME);
        this.compiler.compile("a", this.variableFinder, this.callback);
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).typeOf("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder, (VerificationMode)Mockito.atLeast((int)0))).mapAlias("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).findVariableScope("a");
        ((RuleExpressionCompilerCallback)Mockito.verify((Object)this.callback)).failed(Mockito.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.variableFinder, this.callback});
    }

    @Test
    public void booleanTypeVariablesAreNotCompleteExpressions() throws Exception {
        Mockito.when((Object)this.variableFinder.typeOf("a")).thenReturn((Object)ValueType.BOOLEAN);
        this.compiler.compile("a", this.variableFinder, this.callback);
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).typeOf("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder, (VerificationMode)Mockito.atLeast((int)0))).mapAlias("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).findVariableScope("a");
        ((RuleExpressionCompilerCallback)Mockito.verify((Object)this.callback)).failed(Mockito.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.variableFinder, this.callback});
    }

    @Test
    public void expressionShouldEvaluateToBoolean() throws Exception {
        Mockito.when((Object)this.variableFinder.typeOf("a")).thenReturn((Object)ValueType.INTEGER);
        this.compiler.compile("a + 1", this.variableFinder, this.callback);
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).typeOf("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder, (VerificationMode)Mockito.atLeast((int)0))).mapAlias("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).findVariableScope("a");
        ((RuleExpressionCompilerCallback)Mockito.verify((Object)this.callback)).failed(Mockito.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.variableFinder, this.callback});
    }

    @Test
    @Disabled
    public void functionsEvaluatingToNonBooleanAreNotAccepted() throws Exception {
        Mockito.when((Object)this.variableFinder.typeOf("a")).thenReturn((Object)ValueType.INTEGER);
        Mockito.when((Object)this.variableFinder.returnTypeOf("value", new ValueType[0])).thenReturn((Object)ValueType.INTEGER);
        this.compiler.compile("value(a)", this.variableFinder, this.callback);
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).typeOf("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder, (VerificationMode)Mockito.atLeast((int)0))).mapAlias("a");
        ((VariableFinder)Mockito.verify((Object)this.variableFinder)).findVariableScope("a");
        ((RuleExpressionCompilerCallback)Mockito.verify((Object)this.callback)).failed(Mockito.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.variableFinder, this.callback});
    }

    @Test
    public void constantNonBooleanExpressionsAreNotAccepted() throws Exception {
        this.compiler.compile("1", this.variableFinder, this.callback);
        this.compiler.compile("1.0", this.variableFinder, this.callback);
        this.compiler.compile("\"a\"", this.variableFinder, this.callback);
        ((RuleExpressionCompilerCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)3))).failed(Mockito.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.variableFinder, this.callback});
    }

    @Test
    public void shouldRenameId() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x + 1", this.compiler.createIdRenamer("x", "x").apply("x + 1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"y + 1", this.compiler.createIdRenamer("x", "y").apply("x + 1"));
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionOnBlankIds() {
        Assertions.assertThatThrownBy(() -> this.compiler.createIdRenamer("", "x")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldNotHandleInvalidExpressions() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x + ", this.compiler.createIdRenamer("x", "y").apply("x + "));
    }
}

