package io.dialob.security.spring.oauth2.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Tenant}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTenant.builder()}.
 */
@Generated(from = "Tenant", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTenant implements Tenant {
  private final String id;
  private final @Nullable String name;

  private ImmutableTenant(String id, @Nullable String name) {
    this.id = id;
    this.name = name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tenant#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTenant withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTenant(newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tenant#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTenant withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableTenant(this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTenant} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTenant
        && equalTo(0, (ImmutableTenant) another);
  }

  private boolean equalTo(int synthetic, ImmutableTenant another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code Tenant} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tenant{"
        + "id=" + id
        + ", name=" + name
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Tenant} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tenant instance
   */
  public static ImmutableTenant copyOf(Tenant instance) {
    if (instance instanceof ImmutableTenant) {
      return (ImmutableTenant) instance;
    }
    return ImmutableTenant.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTenant ImmutableTenant}.
   * <pre>
   * ImmutableTenant.builder()
   *    .id(String) // required {@link Tenant#getId() id}
   *    .name(String | null) // nullable {@link Tenant#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableTenant builder
   */
  public static ImmutableTenant.Builder builder() {
    return new ImmutableTenant.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTenant ImmutableTenant}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tenant", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Tenant} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Tenant instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Tenant#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Tenant#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTenant ImmutableTenant}.
     * @return An immutable instance of Tenant
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTenant build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTenant(id, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Tenant, some of required attributes are not set " + attributes;
    }
  }
}
