package io.dialob.security.spring.oauth2.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Token}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToken.builder()}.
 */
@Generated(from = "Token", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableToken implements Token {
  private final @Nullable String accessToken;
  private final String tokenType;
  private final Integer expiresIn;
  private final @Nullable String scope;
  private final @Nullable String idToken;

  private ImmutableToken(
      @Nullable String accessToken,
      String tokenType,
      Integer expiresIn,
      @Nullable String scope,
      @Nullable String idToken) {
    this.accessToken = accessToken;
    this.tokenType = tokenType;
    this.expiresIn = expiresIn;
    this.scope = scope;
    this.idToken = idToken;
  }

  /**
   * @return The value of the {@code accessToken} attribute
   */
  @JsonProperty("access_token")
  @Override
  public @Nullable String getAccessToken() {
    return accessToken;
  }

  /**
   * @return The value of the {@code tokenType} attribute
   */
  @JsonProperty("token_type")
  @Override
  public String getTokenType() {
    return tokenType;
  }

  /**
   * @return The value of the {@code expiresIn} attribute
   */
  @JsonProperty("expires_in")
  @Override
  public Integer getExpiresIn() {
    return expiresIn;
  }

  /**
   * @return The value of the {@code scope} attribute
   */
  @JsonProperty("scope")
  @Override
  public @Nullable String getScope() {
    return scope;
  }

  /**
   * @return The value of the {@code idToken} attribute
   */
  @JsonProperty("id_token")
  @Override
  public @Nullable String getIdToken() {
    return idToken;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#getAccessToken() accessToken} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessToken (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withAccessToken(@Nullable String value) {
    if (Objects.equals(this.accessToken, value)) return this;
    return new ImmutableToken(value, this.tokenType, this.expiresIn, this.scope, this.idToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#getTokenType() tokenType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tokenType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withTokenType(String value) {
    String newValue = Objects.requireNonNull(value, "tokenType");
    if (this.tokenType.equals(newValue)) return this;
    return new ImmutableToken(this.accessToken, newValue, this.expiresIn, this.scope, this.idToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#getExpiresIn() expiresIn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expiresIn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withExpiresIn(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "expiresIn");
    if (this.expiresIn.equals(newValue)) return this;
    return new ImmutableToken(this.accessToken, this.tokenType, newValue, this.scope, this.idToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#getScope() scope} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scope (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withScope(@Nullable String value) {
    if (Objects.equals(this.scope, value)) return this;
    return new ImmutableToken(this.accessToken, this.tokenType, this.expiresIn, value, this.idToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#getIdToken() idToken} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for idToken (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withIdToken(@Nullable String value) {
    if (Objects.equals(this.idToken, value)) return this;
    return new ImmutableToken(this.accessToken, this.tokenType, this.expiresIn, this.scope, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToken
        && equalTo(0, (ImmutableToken) another);
  }

  private boolean equalTo(int synthetic, ImmutableToken another) {
    return Objects.equals(accessToken, another.accessToken)
        && tokenType.equals(another.tokenType)
        && expiresIn.equals(another.expiresIn)
        && Objects.equals(scope, another.scope)
        && Objects.equals(idToken, another.idToken);
  }

  /**
   * Computes a hash code from attributes: {@code accessToken}, {@code tokenType}, {@code expiresIn}, {@code scope}, {@code idToken}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(accessToken);
    h += (h << 5) + tokenType.hashCode();
    h += (h << 5) + expiresIn.hashCode();
    h += (h << 5) + Objects.hashCode(scope);
    h += (h << 5) + Objects.hashCode(idToken);
    return h;
  }

  /**
   * Prints the immutable value {@code Token} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Token{"
        + "accessToken=" + accessToken
        + ", tokenType=" + tokenType
        + ", expiresIn=" + expiresIn
        + ", scope=" + scope
        + ", idToken=" + idToken
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Token", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Token {
    @javax.annotation.Nullable String accessToken;
    @javax.annotation.Nullable String tokenType;
    @javax.annotation.Nullable Integer expiresIn;
    @javax.annotation.Nullable String scope;
    @javax.annotation.Nullable String idToken;
    @JsonProperty("access_token")
    public void setAccessToken(@Nullable String accessToken) {
      this.accessToken = accessToken;
    }
    @JsonProperty("token_type")
    public void setTokenType(String tokenType) {
      this.tokenType = tokenType;
    }
    @JsonProperty("expires_in")
    public void setExpiresIn(Integer expiresIn) {
      this.expiresIn = expiresIn;
    }
    @JsonProperty("scope")
    public void setScope(@Nullable String scope) {
      this.scope = scope;
    }
    @JsonProperty("id_token")
    public void setIdToken(@Nullable String idToken) {
      this.idToken = idToken;
    }
    @Override
    public String getAccessToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getExpiresIn() { throw new UnsupportedOperationException(); }
    @Override
    public String getScope() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdToken() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableToken fromJson(Json json) {
    ImmutableToken.Builder builder = ImmutableToken.builder();
    if (json.accessToken != null) {
      builder.accessToken(json.accessToken);
    }
    if (json.tokenType != null) {
      builder.tokenType(json.tokenType);
    }
    if (json.expiresIn != null) {
      builder.expiresIn(json.expiresIn);
    }
    if (json.scope != null) {
      builder.scope(json.scope);
    }
    if (json.idToken != null) {
      builder.idToken(json.idToken);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Token} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Token instance
   */
  public static ImmutableToken copyOf(Token instance) {
    if (instance instanceof ImmutableToken) {
      return (ImmutableToken) instance;
    }
    return ImmutableToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToken ImmutableToken}.
   * <pre>
   * ImmutableToken.builder()
   *    .accessToken(String | null) // nullable {@link Token#getAccessToken() accessToken}
   *    .tokenType(String) // required {@link Token#getTokenType() tokenType}
   *    .expiresIn(Integer) // required {@link Token#getExpiresIn() expiresIn}
   *    .scope(String | null) // nullable {@link Token#getScope() scope}
   *    .idToken(String | null) // nullable {@link Token#getIdToken() idToken}
   *    .build();
   * </pre>
   * @return A new ImmutableToken builder
   */
  public static ImmutableToken.Builder builder() {
    return new ImmutableToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToken ImmutableToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Token", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_TYPE = 0x1L;
    private static final long INIT_BIT_EXPIRES_IN = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String accessToken;
    private @javax.annotation.Nullable String tokenType;
    private @javax.annotation.Nullable Integer expiresIn;
    private @javax.annotation.Nullable String scope;
    private @javax.annotation.Nullable String idToken;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Token} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Token instance) {
      Objects.requireNonNull(instance, "instance");
      String accessTokenValue = instance.getAccessToken();
      if (accessTokenValue != null) {
        accessToken(accessTokenValue);
      }
      this.tokenType(instance.getTokenType());
      this.expiresIn(instance.getExpiresIn());
      String scopeValue = instance.getScope();
      if (scopeValue != null) {
        scope(scopeValue);
      }
      String idTokenValue = instance.getIdToken();
      if (idTokenValue != null) {
        idToken(idTokenValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Token#getAccessToken() accessToken} attribute.
     * @param accessToken The value for accessToken (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access_token")
    public final Builder accessToken(@Nullable String accessToken) {
      this.accessToken = accessToken;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#getTokenType() tokenType} attribute.
     * @param tokenType The value for tokenType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_type")
    public final Builder tokenType(String tokenType) {
      this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
      initBits &= ~INIT_BIT_TOKEN_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#getExpiresIn() expiresIn} attribute.
     * @param expiresIn The value for expiresIn 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expires_in")
    public final Builder expiresIn(Integer expiresIn) {
      this.expiresIn = Objects.requireNonNull(expiresIn, "expiresIn");
      initBits &= ~INIT_BIT_EXPIRES_IN;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#getScope() scope} attribute.
     * @param scope The value for scope (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scope(@Nullable String scope) {
      this.scope = scope;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#getIdToken() idToken} attribute.
     * @param idToken The value for idToken (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id_token")
    public final Builder idToken(@Nullable String idToken) {
      this.idToken = idToken;
      return this;
    }

    /**
     * Builds a new {@link ImmutableToken ImmutableToken}.
     * @return An immutable instance of Token
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToken build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToken(accessToken, tokenType, expiresIn, scope, idToken);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN_TYPE) != 0) attributes.add("tokenType");
      if ((initBits & INIT_BIT_EXPIRES_IN) != 0) attributes.add("expiresIn");
      return "Cannot build Token, some of required attributes are not set " + attributes;
    }
  }
}
