package io.dialob.security.spring.oauth2.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link User}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUser.builder()}.
 */
@Generated(from = "User", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableUser implements User {
  private final String id;
  private final String userName;
  private final @Nullable String displayName;
  private final @Nullable String firstName;
  private final @Nullable String lastName;
  private final @Nullable String email;
  private final @Nullable Locale locale;
  private final @Nullable ZoneId zoneId;
  private final boolean isAnonymous;
  private final List<Group> groups;
  private final Map<String, String> attributes;

  private ImmutableUser(ImmutableUser.Builder builder) {
    this.id = builder.id;
    this.userName = builder.userName;
    if (builder.displayNameIsSet()) {
      initShim.displayName(builder.displayName);
    }
    if (builder.firstNameIsSet()) {
      initShim.firstName(builder.firstName);
    }
    if (builder.lastNameIsSet()) {
      initShim.lastName(builder.lastName);
    }
    if (builder.emailIsSet()) {
      initShim.email(builder.email);
    }
    if (builder.localeIsSet()) {
      initShim.locale(builder.locale);
    }
    if (builder.zoneIdIsSet()) {
      initShim.zoneId(builder.zoneId);
    }
    if (builder.isAnonymousIsSet()) {
      initShim.isAnonymous(builder.isAnonymous);
    }
    if (builder.groupsIsSet()) {
      initShim.groups(createUnmodifiableList(true, builder.groups));
    }
    if (builder.attributesIsSet()) {
      initShim.attributes(createUnmodifiableMap(false, false, builder.attributes));
    }
    this.displayName = initShim.getDisplayName();
    this.firstName = initShim.getFirstName();
    this.lastName = initShim.getLastName();
    this.email = initShim.getEmail();
    this.locale = initShim.getLocale();
    this.zoneId = initShim.getZoneId();
    this.isAnonymous = initShim.isAnonymous();
    this.groups = initShim.getGroups();
    this.attributes = initShim.getAttributes();
    this.initShim = null;
  }

  private ImmutableUser(
      String id,
      String userName,
      @Nullable String displayName,
      @Nullable String firstName,
      @Nullable String lastName,
      @Nullable String email,
      @Nullable Locale locale,
      @Nullable ZoneId zoneId,
      boolean isAnonymous,
      List<Group> groups,
      Map<String, String> attributes) {
    this.id = id;
    this.userName = userName;
    this.displayName = displayName;
    this.firstName = firstName;
    this.lastName = lastName;
    this.email = email;
    this.locale = locale;
    this.zoneId = zoneId;
    this.isAnonymous = isAnonymous;
    this.groups = groups;
    this.attributes = attributes;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "User", generator = "Immutables")
  private final class InitShim {
    private byte displayNameBuildStage = STAGE_UNINITIALIZED;
    private String displayName;

    String getDisplayName() {
      if (displayNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (displayNameBuildStage == STAGE_UNINITIALIZED) {
        displayNameBuildStage = STAGE_INITIALIZING;
        this.displayName = getDisplayNameInitialize();
        displayNameBuildStage = STAGE_INITIALIZED;
      }
      return this.displayName;
    }

    void displayName(String displayName) {
      this.displayName = displayName;
      displayNameBuildStage = STAGE_INITIALIZED;
    }

    private byte firstNameBuildStage = STAGE_UNINITIALIZED;
    private String firstName;

    String getFirstName() {
      if (firstNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (firstNameBuildStage == STAGE_UNINITIALIZED) {
        firstNameBuildStage = STAGE_INITIALIZING;
        this.firstName = getFirstNameInitialize();
        firstNameBuildStage = STAGE_INITIALIZED;
      }
      return this.firstName;
    }

    void firstName(String firstName) {
      this.firstName = firstName;
      firstNameBuildStage = STAGE_INITIALIZED;
    }

    private byte lastNameBuildStage = STAGE_UNINITIALIZED;
    private String lastName;

    String getLastName() {
      if (lastNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lastNameBuildStage == STAGE_UNINITIALIZED) {
        lastNameBuildStage = STAGE_INITIALIZING;
        this.lastName = getLastNameInitialize();
        lastNameBuildStage = STAGE_INITIALIZED;
      }
      return this.lastName;
    }

    void lastName(String lastName) {
      this.lastName = lastName;
      lastNameBuildStage = STAGE_INITIALIZED;
    }

    private byte emailBuildStage = STAGE_UNINITIALIZED;
    private String email;

    String getEmail() {
      if (emailBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (emailBuildStage == STAGE_UNINITIALIZED) {
        emailBuildStage = STAGE_INITIALIZING;
        this.email = getEmailInitialize();
        emailBuildStage = STAGE_INITIALIZED;
      }
      return this.email;
    }

    void email(String email) {
      this.email = email;
      emailBuildStage = STAGE_INITIALIZED;
    }

    private byte localeBuildStage = STAGE_UNINITIALIZED;
    private Locale locale;

    Locale getLocale() {
      if (localeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (localeBuildStage == STAGE_UNINITIALIZED) {
        localeBuildStage = STAGE_INITIALIZING;
        this.locale = getLocaleInitialize();
        localeBuildStage = STAGE_INITIALIZED;
      }
      return this.locale;
    }

    void locale(Locale locale) {
      this.locale = locale;
      localeBuildStage = STAGE_INITIALIZED;
    }

    private byte zoneIdBuildStage = STAGE_UNINITIALIZED;
    private ZoneId zoneId;

    ZoneId getZoneId() {
      if (zoneIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zoneIdBuildStage == STAGE_UNINITIALIZED) {
        zoneIdBuildStage = STAGE_INITIALIZING;
        this.zoneId = getZoneIdInitialize();
        zoneIdBuildStage = STAGE_INITIALIZED;
      }
      return this.zoneId;
    }

    void zoneId(ZoneId zoneId) {
      this.zoneId = zoneId;
      zoneIdBuildStage = STAGE_INITIALIZED;
    }

    private byte isAnonymousBuildStage = STAGE_UNINITIALIZED;
    private boolean isAnonymous;

    boolean isAnonymous() {
      if (isAnonymousBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isAnonymousBuildStage == STAGE_UNINITIALIZED) {
        isAnonymousBuildStage = STAGE_INITIALIZING;
        this.isAnonymous = isAnonymousInitialize();
        isAnonymousBuildStage = STAGE_INITIALIZED;
      }
      return this.isAnonymous;
    }

    void isAnonymous(boolean isAnonymous) {
      this.isAnonymous = isAnonymous;
      isAnonymousBuildStage = STAGE_INITIALIZED;
    }

    private byte groupsBuildStage = STAGE_UNINITIALIZED;
    private List<Group> groups;

    List<Group> getGroups() {
      if (groupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (groupsBuildStage == STAGE_UNINITIALIZED) {
        groupsBuildStage = STAGE_INITIALIZING;
        this.groups = createUnmodifiableList(false, createSafeList(getGroupsInitialize(), true, false));
        groupsBuildStage = STAGE_INITIALIZED;
      }
      return this.groups;
    }

    void groups(List<Group> groups) {
      this.groups = groups;
      groupsBuildStage = STAGE_INITIALIZED;
    }

    private byte attributesBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> attributes;

    Map<String, String> getAttributes() {
      if (attributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (attributesBuildStage == STAGE_UNINITIALIZED) {
        attributesBuildStage = STAGE_INITIALIZING;
        this.attributes = createUnmodifiableMap(true, false, getAttributesInitialize());
        attributesBuildStage = STAGE_INITIALIZED;
      }
      return this.attributes;
    }

    void attributes(Map<String, String> attributes) {
      this.attributes = attributes;
      attributesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (displayNameBuildStage == STAGE_INITIALIZING) attributes.add("displayName");
      if (firstNameBuildStage == STAGE_INITIALIZING) attributes.add("firstName");
      if (lastNameBuildStage == STAGE_INITIALIZING) attributes.add("lastName");
      if (emailBuildStage == STAGE_INITIALIZING) attributes.add("email");
      if (localeBuildStage == STAGE_INITIALIZING) attributes.add("locale");
      if (zoneIdBuildStage == STAGE_INITIALIZING) attributes.add("zoneId");
      if (isAnonymousBuildStage == STAGE_INITIALIZING) attributes.add("isAnonymous");
      if (groupsBuildStage == STAGE_INITIALIZING) attributes.add("groups");
      if (attributesBuildStage == STAGE_INITIALIZING) attributes.add("attributes");
      return "Cannot build User, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable String getDisplayNameInitialize() {
    return User.super.getDisplayName();
  }

  private @Nullable String getFirstNameInitialize() {
    return User.super.getFirstName();
  }

  private @Nullable String getLastNameInitialize() {
    return User.super.getLastName();
  }

  private @Nullable String getEmailInitialize() {
    return User.super.getEmail();
  }

  private @Nullable Locale getLocaleInitialize() {
    return User.super.getLocale();
  }

  private @Nullable ZoneId getZoneIdInitialize() {
    return User.super.getZoneId();
  }

  private boolean isAnonymousInitialize() {
    return User.super.isAnonymous();
  }

  private List<Group> getGroupsInitialize() {
    return User.super.getGroups();
  }

  private Map<String, String> getAttributesInitialize() {
    return User.super.getAttributes();
  }

  /**
   * @return Unique user identifier. "sub" from external systems
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return User login id. Eg. email address
   */
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @Override
  public @Nullable String getDisplayName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDisplayName()
        : this.displayName;
  }

  /**
   * @return The value of the {@code firstName} attribute
   */
  @Override
  public @Nullable String getFirstName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFirstName()
        : this.firstName;
  }

  /**
   * @return The value of the {@code lastName} attribute
   */
  @Override
  public @Nullable String getLastName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLastName()
        : this.lastName;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @Override
  public @Nullable String getEmail() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getEmail()
        : this.email;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public @Nullable Locale getLocale() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLocale()
        : this.locale;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @Override
  public @Nullable ZoneId getZoneId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZoneId()
        : this.zoneId;
  }

  /**
   * @return The value of the {@code isAnonymous} attribute
   */
  @Override
  public boolean isAnonymous() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAnonymous()
        : this.isAnonymous;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @Override
  public List<Group> getGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGroups()
        : this.groups;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @Override
  public Map<String, String> getAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAttributes()
        : this.attributes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUser(
        newValue,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getUserName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableUser(
        this.id,
        newValue,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getDisplayName() displayName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withDisplayName(@Nullable String value) {
    if (Objects.equals(this.displayName, value)) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        value,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getFirstName() firstName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withFirstName(@Nullable String value) {
    if (Objects.equals(this.firstName, value)) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        value,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getLastName() lastName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withLastName(@Nullable String value) {
    if (Objects.equals(this.lastName, value)) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        value,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getEmail() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withEmail(@Nullable String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        value,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getLocale() locale} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withLocale(@Nullable Locale value) {
    if (this.locale == value) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        value,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#getZoneId() zoneId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withZoneId(@Nullable ZoneId value) {
    if (this.zoneId == value) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        value,
        this.isAnonymous,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#isAnonymous() isAnonymous} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isAnonymous
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withIsAnonymous(boolean value) {
    if (this.isAnonymous == value) return this;
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        value,
        this.groups,
        this.attributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link User#getGroups() groups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withGroups(Group... elements) {
    List<Group> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        newValue,
        this.attributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link User#getGroups() groups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withGroups(Iterable<? extends Group> elements) {
    if (this.groups == elements) return this;
    List<Group> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        newValue,
        this.attributes);
  }

  /**
   * Copy the current immutable object by replacing the {@link User#getAttributes() attributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the attributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withAttributes(Map<String, ? extends String> entries) {
    if (this.attributes == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableUser(
        this.id,
        this.userName,
        this.displayName,
        this.firstName,
        this.lastName,
        this.email,
        this.locale,
        this.zoneId,
        this.isAnonymous,
        this.groups,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUser
        && equalTo(0, (ImmutableUser) another);
  }

  private boolean equalTo(int synthetic, ImmutableUser another) {
    return id.equals(another.id)
        && userName.equals(another.userName)
        && Objects.equals(displayName, another.displayName)
        && Objects.equals(firstName, another.firstName)
        && Objects.equals(lastName, another.lastName)
        && Objects.equals(email, another.email)
        && Objects.equals(locale, another.locale)
        && Objects.equals(zoneId, another.zoneId)
        && isAnonymous == another.isAnonymous
        && groups.equals(another.groups)
        && attributes.equals(another.attributes);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code userName}, {@code displayName}, {@code firstName}, {@code lastName}, {@code email}, {@code locale}, {@code zoneId}, {@code isAnonymous}, {@code groups}, {@code attributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Objects.hashCode(displayName);
    h += (h << 5) + Objects.hashCode(firstName);
    h += (h << 5) + Objects.hashCode(lastName);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(locale);
    h += (h << 5) + Objects.hashCode(zoneId);
    h += (h << 5) + Boolean.hashCode(isAnonymous);
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + attributes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code User} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "User{"
        + "id=" + id
        + ", userName=" + userName
        + ", displayName=" + displayName
        + ", firstName=" + firstName
        + ", lastName=" + lastName
        + ", email=" + email
        + ", locale=" + locale
        + ", zoneId=" + zoneId
        + ", isAnonymous=" + isAnonymous
        + ", groups=" + groups
        + ", attributes=" + attributes
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link User} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable User instance
   */
  public static ImmutableUser copyOf(User instance) {
    if (instance instanceof ImmutableUser) {
      return (ImmutableUser) instance;
    }
    return ImmutableUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUser ImmutableUser}.
   * <pre>
   * ImmutableUser.builder()
   *    .id(String) // required {@link User#getId() id}
   *    .userName(String) // required {@link User#getUserName() userName}
   *    .displayName(String | null) // nullable {@link User#getDisplayName() displayName}
   *    .firstName(String | null) // nullable {@link User#getFirstName() firstName}
   *    .lastName(String | null) // nullable {@link User#getLastName() lastName}
   *    .email(String | null) // nullable {@link User#getEmail() email}
   *    .locale(Locale | null) // nullable {@link User#getLocale() locale}
   *    .zoneId(java.time.ZoneId | null) // nullable {@link User#getZoneId() zoneId}
   *    .isAnonymous(boolean) // optional {@link User#isAnonymous() isAnonymous}
   *    .addGroups|addAllGroups(io.dialob.security.spring.oauth2.model.Group) // {@link User#getGroups() groups} elements
   *    .putAttributes|putAllAttributes(String =&gt; String) // {@link User#getAttributes() attributes} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableUser builder
   */
  public static ImmutableUser.Builder builder() {
    return new ImmutableUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUser ImmutableUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "User", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_USER_NAME = 0x2L;
    private static final long OPT_BIT_DISPLAY_NAME = 0x1L;
    private static final long OPT_BIT_FIRST_NAME = 0x2L;
    private static final long OPT_BIT_LAST_NAME = 0x4L;
    private static final long OPT_BIT_EMAIL = 0x8L;
    private static final long OPT_BIT_LOCALE = 0x10L;
    private static final long OPT_BIT_ZONE_ID = 0x20L;
    private static final long OPT_BIT_IS_ANONYMOUS = 0x40L;
    private static final long OPT_BIT_GROUPS = 0x80L;
    private static final long OPT_BIT_ATTRIBUTES = 0x100L;
    private long initBits = 0x3L;
    private long optBits;

    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String userName;
    private @javax.annotation.Nullable String displayName;
    private @javax.annotation.Nullable String firstName;
    private @javax.annotation.Nullable String lastName;
    private @javax.annotation.Nullable String email;
    private @javax.annotation.Nullable Locale locale;
    private @javax.annotation.Nullable ZoneId zoneId;
    private boolean isAnonymous;
    private List<Group> groups = new ArrayList<Group>();
    private Map<String, String> attributes = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code User} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(User instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.userName(instance.getUserName());
      String displayNameValue = instance.getDisplayName();
      if (displayNameValue != null) {
        displayName(displayNameValue);
      }
      String firstNameValue = instance.getFirstName();
      if (firstNameValue != null) {
        firstName(firstNameValue);
      }
      String lastNameValue = instance.getLastName();
      if (lastNameValue != null) {
        lastName(lastNameValue);
      }
      String emailValue = instance.getEmail();
      if (emailValue != null) {
        email(emailValue);
      }
      Locale localeValue = instance.getLocale();
      if (localeValue != null) {
        locale(localeValue);
      }
      ZoneId zoneIdValue = instance.getZoneId();
      if (zoneIdValue != null) {
        zoneId(zoneIdValue);
      }
      this.isAnonymous(instance.isAnonymous());
      addAllGroups(instance.getGroups());
      putAllAttributes(instance.getAttributes());
      return this;
    }

    /**
     * Initializes the value for the {@link User#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getDisplayName() displayName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getDisplayName() displayName}.</em>
     * @param displayName The value for displayName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder displayName(@Nullable String displayName) {
      this.displayName = displayName;
      optBits |= OPT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getFirstName() firstName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getFirstName() firstName}.</em>
     * @param firstName The value for firstName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder firstName(@Nullable String firstName) {
      this.firstName = firstName;
      optBits |= OPT_BIT_FIRST_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getLastName() lastName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getLastName() lastName}.</em>
     * @param lastName The value for lastName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastName(@Nullable String lastName) {
      this.lastName = lastName;
      optBits |= OPT_BIT_LAST_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getEmail() email} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getEmail() email}.</em>
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(@Nullable String email) {
      this.email = email;
      optBits |= OPT_BIT_EMAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getLocale() locale} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getLocale() locale}.</em>
     * @param locale The value for locale (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder locale(@Nullable Locale locale) {
      this.locale = locale;
      optBits |= OPT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getZoneId() zoneId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#getZoneId() zoneId}.</em>
     * @param zoneId The value for zoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(@Nullable ZoneId zoneId) {
      this.zoneId = zoneId;
      optBits |= OPT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link User#isAnonymous() isAnonymous} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link User#isAnonymous() isAnonymous}.</em>
     * @param isAnonymous The value for isAnonymous 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isAnonymous(boolean isAnonymous) {
      this.isAnonymous = isAnonymous;
      optBits |= OPT_BIT_IS_ANONYMOUS;
      return this;
    }

    /**
     * Adds one element to {@link User#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(Group element) {
      this.groups.add(Objects.requireNonNull(element, "groups element"));
      optBits |= OPT_BIT_GROUPS;
      return this;
    }

    /**
     * Adds elements to {@link User#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(Group... elements) {
      for (Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      optBits |= OPT_BIT_GROUPS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groups(Iterable<? extends Group> elements) {
      this.groups.clear();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link User#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroups(Iterable<? extends Group> elements) {
      for (Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      optBits |= OPT_BIT_GROUPS;
      return this;
    }

    /**
     * Put one entry to the {@link User#getAttributes() attributes} map.
     * @param key The key in the attributes map
     * @param value The associated value in the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(String key, String value) {
      this.attributes.put(
          Objects.requireNonNull(key, "attributes key"),
          Objects.requireNonNull(value, value == null ? "attributes value for key: " + key : null));
      optBits |= OPT_BIT_ATTRIBUTES;
      return this;
    }

    /**
     * Put one entry to the {@link User#getAttributes() attributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.attributes.put(
          Objects.requireNonNull(k, "attributes key"),
          Objects.requireNonNull(v, v == null ? "attributes value for key: " + k : null));
      optBits |= OPT_BIT_ATTRIBUTES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link User#getAttributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder attributes(Map<String, ? extends String> entries) {
      this.attributes.clear();
      optBits |= OPT_BIT_ATTRIBUTES;
      return putAllAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link User#getAttributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAttributes(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.attributes.put(
            Objects.requireNonNull(k, "attributes key"),
            Objects.requireNonNull(v, v == null ? "attributes value for key: " + k : null));
      }
      optBits |= OPT_BIT_ATTRIBUTES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUser ImmutableUser}.
     * @return An immutable instance of User
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUser(this);
    }

    private boolean displayNameIsSet() {
      return (optBits & OPT_BIT_DISPLAY_NAME) != 0;
    }

    private boolean firstNameIsSet() {
      return (optBits & OPT_BIT_FIRST_NAME) != 0;
    }

    private boolean lastNameIsSet() {
      return (optBits & OPT_BIT_LAST_NAME) != 0;
    }

    private boolean emailIsSet() {
      return (optBits & OPT_BIT_EMAIL) != 0;
    }

    private boolean localeIsSet() {
      return (optBits & OPT_BIT_LOCALE) != 0;
    }

    private boolean zoneIdIsSet() {
      return (optBits & OPT_BIT_ZONE_ID) != 0;
    }

    private boolean isAnonymousIsSet() {
      return (optBits & OPT_BIT_IS_ANONYMOUS) != 0;
    }

    private boolean groupsIsSet() {
      return (optBits & OPT_BIT_GROUPS) != 0;
    }

    private boolean attributesIsSet() {
      return (optBits & OPT_BIT_ATTRIBUTES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build User, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
