package io.dialob.security.spring.tenant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.springframework.security.core.GrantedAuthority;

/**
 * Immutable implementation of {@link GroupGrantedAuthority}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroupGrantedAuthority.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableGroupGrantedAuthority.of()}.
 */
@Generated(from = "GroupGrantedAuthority", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableGroupGrantedAuthority
    implements GroupGrantedAuthority {
  private final String groupId;
  private final String authority;

  private ImmutableGroupGrantedAuthority(String groupId, String authority) {
    this.groupId = Objects.requireNonNull(groupId, "groupId");
    this.authority = Objects.requireNonNull(authority, "authority");
  }

  private ImmutableGroupGrantedAuthority(ImmutableGroupGrantedAuthority original, String groupId, String authority) {
    this.groupId = groupId;
    this.authority = authority;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Group's display name as authority
   * @return tenant display name
   */
  @JsonProperty("authority")
  @Override
  public String getAuthority() {
    return authority;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupGrantedAuthority#getGroupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupGrantedAuthority withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableGroupGrantedAuthority(this, newValue, this.authority);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupGrantedAuthority#getAuthority() authority} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authority
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupGrantedAuthority withAuthority(String value) {
    String newValue = Objects.requireNonNull(value, "authority");
    if (this.authority.equals(newValue)) return this;
    return new ImmutableGroupGrantedAuthority(this, this.groupId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroupGrantedAuthority} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroupGrantedAuthority
        && equalTo(0, (ImmutableGroupGrantedAuthority) another);
  }

  private boolean equalTo(int synthetic, ImmutableGroupGrantedAuthority another) {
    return groupId.equals(another.groupId)
        && authority.equals(another.authority);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code authority}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + authority.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GroupGrantedAuthority} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GroupGrantedAuthority{"
        + "groupId=" + groupId
        + ", authority=" + authority
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GroupGrantedAuthority", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GroupGrantedAuthority {
    @Nullable String groupId;
    @Nullable String authority;
    @JsonProperty("groupId")
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("authority")
    public void setAuthority(String authority) {
      this.authority = authority;
    }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthority() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGroupGrantedAuthority fromJson(Json json) {
    ImmutableGroupGrantedAuthority.Builder builder = ImmutableGroupGrantedAuthority.builder();
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.authority != null) {
      builder.authority(json.authority);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code GroupGrantedAuthority} instance.
   * @param groupId The value for the {@code groupId} attribute
   * @param authority The value for the {@code authority} attribute
   * @return An immutable GroupGrantedAuthority instance
   */
  public static ImmutableGroupGrantedAuthority of(String groupId, String authority) {
    return new ImmutableGroupGrantedAuthority(groupId, authority);
  }

  /**
   * Creates an immutable copy of a {@link GroupGrantedAuthority} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GroupGrantedAuthority instance
   */
  public static ImmutableGroupGrantedAuthority copyOf(GroupGrantedAuthority instance) {
    if (instance instanceof ImmutableGroupGrantedAuthority) {
      return (ImmutableGroupGrantedAuthority) instance;
    }
    return ImmutableGroupGrantedAuthority.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroupGrantedAuthority ImmutableGroupGrantedAuthority}.
   * <pre>
   * ImmutableGroupGrantedAuthority.builder()
   *    .groupId(String) // required {@link GroupGrantedAuthority#getGroupId() groupId}
   *    .authority(String) // required {@link GroupGrantedAuthority#getAuthority() authority}
   *    .build();
   * </pre>
   * @return A new ImmutableGroupGrantedAuthority builder
   */
  public static ImmutableGroupGrantedAuthority.Builder builder() {
    return new ImmutableGroupGrantedAuthority.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroupGrantedAuthority ImmutableGroupGrantedAuthority}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GroupGrantedAuthority", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_AUTHORITY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String groupId;
    private @Nullable String authority;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.spring.tenant.GroupGrantedAuthority} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GroupGrantedAuthority instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.springframework.security.core.GrantedAuthority} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GrantedAuthority instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof GroupGrantedAuthority) {
        GroupGrantedAuthority instance = (GroupGrantedAuthority) object;
        this.groupId(instance.getGroupId());
        if ((bits & 0x1L) == 0) {
          this.authority(instance.getAuthority());
          bits |= 0x1L;
        }
      }
      if (object instanceof GrantedAuthority) {
        GrantedAuthority instance = (GrantedAuthority) object;
        if ((bits & 0x1L) == 0) {
          this.authority(instance.getAuthority());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GroupGrantedAuthority#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GroupGrantedAuthority#getAuthority() authority} attribute.
     * @param authority The value for authority 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authority")
    public final Builder authority(String authority) {
      this.authority = Objects.requireNonNull(authority, "authority");
      initBits &= ~INIT_BIT_AUTHORITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroupGrantedAuthority ImmutableGroupGrantedAuthority}.
     * @return An immutable instance of GroupGrantedAuthority
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroupGrantedAuthority build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroupGrantedAuthority(null, groupId, authority);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_AUTHORITY) != 0) attributes.add("authority");
      return "Cannot build GroupGrantedAuthority, some of required attributes are not set " + attributes;
    }
  }
}
