package io.dialob.security.spring.tenant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.springframework.security.core.GrantedAuthority;

/**
 * Immutable implementation of {@link TenantGrantedAuthority}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTenantGrantedAuthority.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTenantGrantedAuthority.of()}.
 */
@Generated(from = "TenantGrantedAuthority", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTenantGrantedAuthority
    implements TenantGrantedAuthority {
  private final String tenantId;
  private final String authority;

  private ImmutableTenantGrantedAuthority(String tenantId, String authority) {
    this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
    this.authority = Objects.requireNonNull(authority, "authority");
  }

  private ImmutableTenantGrantedAuthority(ImmutableTenantGrantedAuthority original, String tenantId, String authority) {
    this.tenantId = tenantId;
    this.authority = authority;
  }

  /**
   * @return The value of the {@code tenantId} attribute
   */
  @JsonProperty("tenantId")
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * Tenant's display name as authority
   * @return tenant display name
   */
  @JsonProperty("authority")
  @Override
  public String getAuthority() {
    return authority;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TenantGrantedAuthority#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTenantGrantedAuthority withTenantId(String value) {
    String newValue = Objects.requireNonNull(value, "tenantId");
    if (this.tenantId.equals(newValue)) return this;
    return new ImmutableTenantGrantedAuthority(this, newValue, this.authority);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TenantGrantedAuthority#getAuthority() authority} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authority
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTenantGrantedAuthority withAuthority(String value) {
    String newValue = Objects.requireNonNull(value, "authority");
    if (this.authority.equals(newValue)) return this;
    return new ImmutableTenantGrantedAuthority(this, this.tenantId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTenantGrantedAuthority} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTenantGrantedAuthority
        && equalTo(0, (ImmutableTenantGrantedAuthority) another);
  }

  private boolean equalTo(int synthetic, ImmutableTenantGrantedAuthority another) {
    return tenantId.equals(another.tenantId)
        && authority.equals(another.authority);
  }

  /**
   * Computes a hash code from attributes: {@code tenantId}, {@code authority}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenantId.hashCode();
    h += (h << 5) + authority.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TenantGrantedAuthority} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TenantGrantedAuthority{"
        + "tenantId=" + tenantId
        + ", authority=" + authority
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TenantGrantedAuthority", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TenantGrantedAuthority {
    @Nullable String tenantId;
    @Nullable String authority;
    @JsonProperty("tenantId")
    public void setTenantId(String tenantId) {
      this.tenantId = tenantId;
    }
    @JsonProperty("authority")
    public void setAuthority(String authority) {
      this.authority = authority;
    }
    @Override
    public String getTenantId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthority() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTenantGrantedAuthority fromJson(Json json) {
    ImmutableTenantGrantedAuthority.Builder builder = ImmutableTenantGrantedAuthority.builder();
    if (json.tenantId != null) {
      builder.tenantId(json.tenantId);
    }
    if (json.authority != null) {
      builder.authority(json.authority);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code TenantGrantedAuthority} instance.
   * @param tenantId The value for the {@code tenantId} attribute
   * @param authority The value for the {@code authority} attribute
   * @return An immutable TenantGrantedAuthority instance
   */
  public static ImmutableTenantGrantedAuthority of(String tenantId, String authority) {
    return new ImmutableTenantGrantedAuthority(tenantId, authority);
  }

  /**
   * Creates an immutable copy of a {@link TenantGrantedAuthority} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TenantGrantedAuthority instance
   */
  public static ImmutableTenantGrantedAuthority copyOf(TenantGrantedAuthority instance) {
    if (instance instanceof ImmutableTenantGrantedAuthority) {
      return (ImmutableTenantGrantedAuthority) instance;
    }
    return ImmutableTenantGrantedAuthority.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTenantGrantedAuthority ImmutableTenantGrantedAuthority}.
   * <pre>
   * ImmutableTenantGrantedAuthority.builder()
   *    .tenantId(String) // required {@link TenantGrantedAuthority#getTenantId() tenantId}
   *    .authority(String) // required {@link TenantGrantedAuthority#getAuthority() authority}
   *    .build();
   * </pre>
   * @return A new ImmutableTenantGrantedAuthority builder
   */
  public static ImmutableTenantGrantedAuthority.Builder builder() {
    return new ImmutableTenantGrantedAuthority.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTenantGrantedAuthority ImmutableTenantGrantedAuthority}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TenantGrantedAuthority", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT_ID = 0x1L;
    private static final long INIT_BIT_AUTHORITY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String tenantId;
    private @Nullable String authority;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.springframework.security.core.GrantedAuthority} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GrantedAuthority instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.spring.tenant.TenantGrantedAuthority} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantGrantedAuthority instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof GrantedAuthority) {
        GrantedAuthority instance = (GrantedAuthority) object;
        if ((bits & 0x1L) == 0) {
          this.authority(instance.getAuthority());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantGrantedAuthority) {
        TenantGrantedAuthority instance = (TenantGrantedAuthority) object;
        this.tenantId(instance.getTenantId());
        if ((bits & 0x1L) == 0) {
          this.authority(instance.getAuthority());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link TenantGrantedAuthority#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenantId")
    public final Builder tenantId(String tenantId) {
      this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
      initBits &= ~INIT_BIT_TENANT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TenantGrantedAuthority#getAuthority() authority} attribute.
     * @param authority The value for authority 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authority")
    public final Builder authority(String authority) {
      this.authority = Objects.requireNonNull(authority, "authority");
      initBits &= ~INIT_BIT_AUTHORITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTenantGrantedAuthority ImmutableTenantGrantedAuthority}.
     * @return An immutable instance of TenantGrantedAuthority
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTenantGrantedAuthority build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTenantGrantedAuthority(null, tenantId, authority);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT_ID) != 0) attributes.add("tenantId");
      if ((initBits & INIT_BIT_AUTHORITY) != 0) attributes.add("authority");
      return "Cannot build TenantGrantedAuthority, some of required attributes are not set " + attributes;
    }
  }
}
