/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.session.engine.AbstractFormActionsVisitor;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class AbstractFormActionsUpdatesItemsVisitor
extends AbstractFormActionsVisitor
implements EvalContext.UpdatedItemsVisitor {
    private final Predicate<SessionObject> isVisiblePredicate;

    AbstractFormActionsUpdatesItemsVisitor(@Nonnull FormActions formActions, @Nonnull Predicate<SessionObject> isVisiblePredicate) {
        super(formActions);
        this.isVisiblePredicate = isVisiblePredicate;
    }

    @Override
    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedSessionStateVisitor> visitSession() {
        return Optional.of((original, updated) -> this.languageChanged(updated));
    }

    @Override
    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedErrorStateVisitor> visitUpdatedErrorStates() {
        return Optional.of((original, updated) -> {
            boolean originalVisible;
            boolean updatedVisible = updated != null && this.isVisiblePredicate.test(updated);
            boolean bl = originalVisible = original != null && this.isVisiblePredicate.test(original);
            if (originalVisible && !updatedVisible) {
                this.inactivated(original);
                return;
            }
            if (!originalVisible && updatedVisible) {
                this.activated(updated);
                return;
            }
            if (updatedVisible) {
                this.updated(updated);
            }
        });
    }

    @Override
    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedItemStateVisitor> visitUpdatedItems() {
        return Optional.of((original, updated) -> {
            boolean originalVisible;
            boolean updatedVisible = updated != null && this.isVisiblePredicate.test(updated);
            boolean bl = originalVisible = original != null && this.isVisiblePredicate.test(original);
            if (!originalVisible && !updatedVisible) {
                return;
            }
            if (originalVisible && !updatedVisible) {
                this.inactivated(updated != null ? updated : original);
                return;
            }
            if (!originalVisible) {
                this.activated(updated);
                return;
            }
            if (original.isDisabled() && !updated.isDisabled()) {
                this.enabled(updated);
                return;
            }
            if (!original.isDisabled() && updated.isDisabled()) {
                this.disabled(updated);
                return;
            }
            if (!Objects.equals(original, updated)) {
                this.updated(updated);
            }
        });
    }

    @Override
    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedValueSetVisitor> visitUpdatedValueSets() {
        return Optional.of((original, updated) -> {
            if (updated != null) {
                this.updated(updated);
            }
        });
    }

    protected abstract void updated(@Nonnull ErrorState var1);

    protected abstract void updated(@Nonnull ValueSetState var1);

    protected abstract void activated(@Nonnull ErrorState var1);

    protected abstract void inactivated(@Nonnull ErrorState var1);

    protected abstract void disabled(@Nonnull ItemState var1);

    protected abstract void enabled(@Nonnull ItemState var1);

    protected abstract void activated(@Nonnull ItemState var1);

    protected abstract void inactivated(@Nonnull ItemState var1);

    protected abstract void updated(@Nonnull ItemState var1);

    protected abstract void languageChanged(@Nonnull String var1);
}

