/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import io.dialob.api.proto.ActionItem;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.session.engine.AbstractFormActionsUpdatesItemsVisitor;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FormActionsUpdatesItemsVisitor
extends AbstractFormActionsUpdatesItemsVisitor {
    private final Function<ItemState, ActionItem> toActionItemFunction;

    public FormActionsUpdatesItemsVisitor(@Nonnull FormActions formActions, @Nonnull Predicate<SessionObject> isVisiblePredicate, @Nonnull Function<ItemState, ActionItem> toActionItemFunction) {
        super(formActions, isVisiblePredicate);
        this.toActionItemFunction = toActionItemFunction;
    }

    @Override
    protected void updated(@Nonnull ErrorState updated) {
        this.formActions.addError(Utils.toError(updated));
    }

    @Override
    protected void updated(@Nonnull ValueSetState updated) {
        this.formActions.newValueSet(Utils.toValueSet(updated));
    }

    @Override
    protected void activated(@Nonnull ErrorState updated) {
        this.formActions.addError(Utils.toError(updated));
    }

    @Override
    protected void inactivated(@Nonnull ErrorState updated) {
        this.formActions.removeError((Error)ImmutableError.builder().id(IdUtils.toString(updated.getItemId())).code(updated.getCode()).build());
    }

    @Override
    protected void disabled(@Nonnull ItemState updated) {
        this.updated(updated);
    }

    @Override
    protected void enabled(@Nonnull ItemState updated) {
        this.updated(updated);
    }

    @Override
    protected void activated(@Nonnull ItemState updated) {
        this.formActions.newQuestion(this.toActionItemFunction.apply(updated));
    }

    @Override
    protected void inactivated(@Nonnull ItemState updated) {
        this.formActions.removeQuestion(IdUtils.toString(updated.getId()));
    }

    @Override
    protected void updated(@Nonnull ItemState updated) {
        this.formActions.updateQuestion(this.toActionItemFunction.apply(updated));
    }

    @Override
    protected void languageChanged(@Nonnull String language) {
        this.formActions.locale(new Locale(language));
    }

    @Override
    public void visitCompleted() {
        this.formActions.complete();
    }
}

