/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.Constant;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Constant", generator="Immutables")
@Immutable
public final class ImmutableConstant<T>
implements Constant<T> {
    private final T value;
    private final ValueType valueType;

    private ImmutableConstant(T value, ValueType valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    public final ImmutableConstant<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableConstant<T>(newValue, this.valueType);
    }

    public final ImmutableConstant<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableConstant<T>(this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConstant && this.equalTo((ImmutableConstant)another);
    }

    private boolean equalTo(ImmutableConstant<?> another) {
        return this.value.equals(another.value) && this.valueType.equals(another.valueType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.valueType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Constant").omitNullValues().add("value", this.value).add("valueType", (Object)this.valueType).toString();
    }

    public static <T> ImmutableConstant<T> copyOf(Constant<T> instance) {
        if (instance instanceof ImmutableConstant) {
            return (ImmutableConstant)instance;
        }
        return ImmutableConstant.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="Constant", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_VALUE_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private T value;
        @Nullable
        private ValueType valueType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Constant<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Expression instance;
            long bits = 0L;
            if (object instanceof Constant) {
                instance = (Constant)object;
                this.value(instance.getValue());
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
            if (object instanceof Expression) {
                instance = (Expression)object;
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableConstant<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConstant<T>(this.value, this.valueType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("valueType");
            }
            return "Cannot build Constant, some of required attributes are not set " + attributes;
        }
    }
}

