/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.FunctionCallOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FunctionCallOperator", generator="Immutables")
@Immutable
public final class ImmutableFunctionCallOperator
implements FunctionCallOperator {
    private final ValueType valueType;
    private final String functionName;
    private final ImmutableList<Expression> args;

    private ImmutableFunctionCallOperator(ValueType valueType, String functionName, ImmutableList<Expression> args) {
        this.valueType = valueType;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public ImmutableList<Expression> getArgs() {
        return this.args;
    }

    public final ImmutableFunctionCallOperator withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableFunctionCallOperator(newValue, this.functionName, this.args);
    }

    public final ImmutableFunctionCallOperator withFunctionName(String value) {
        String newValue = Objects.requireNonNull(value, "functionName");
        if (this.functionName.equals(newValue)) {
            return this;
        }
        return new ImmutableFunctionCallOperator(this.valueType, newValue, this.args);
    }

    public final ImmutableFunctionCallOperator withArgs(Expression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFunctionCallOperator(this.valueType, this.functionName, (ImmutableList<Expression>)newValue);
    }

    public final ImmutableFunctionCallOperator withArgs(Iterable<? extends Expression> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFunctionCallOperator(this.valueType, this.functionName, (ImmutableList<Expression>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFunctionCallOperator && this.equalTo((ImmutableFunctionCallOperator)another);
    }

    private boolean equalTo(ImmutableFunctionCallOperator another) {
        return this.valueType.equals(another.valueType) && this.functionName.equals(another.functionName) && this.args.equals(another.args);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.functionName.hashCode();
        h += (h << 5) + this.args.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FunctionCallOperator").omitNullValues().add("valueType", (Object)this.valueType).add("functionName", (Object)this.functionName).add("args", this.args).toString();
    }

    public static ImmutableFunctionCallOperator copyOf(FunctionCallOperator instance) {
        if (instance instanceof ImmutableFunctionCallOperator) {
            return (ImmutableFunctionCallOperator)instance;
        }
        return ImmutableFunctionCallOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FunctionCallOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_TYPE = 1L;
        private static final long INIT_BIT_FUNCTION_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private ValueType valueType;
        @Nullable
        private String functionName;
        private ImmutableList.Builder<Expression> args = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FunctionCallOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Expression instance;
            long bits = 0L;
            if (object instanceof FunctionCallOperator) {
                instance = (FunctionCallOperator)object;
                this.addAllArgs(instance.getArgs());
                this.functionName(instance.getFunctionName());
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
            if (object instanceof Expression) {
                instance = (Expression)object;
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder functionName(String functionName) {
            this.functionName = Objects.requireNonNull(functionName, "functionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(Expression element) {
            this.args.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(Expression ... elements) {
            this.args.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Iterable<? extends Expression> elements) {
            this.args = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArgs(Iterable<? extends Expression> elements) {
            this.args.addAll(elements);
            return this;
        }

        public ImmutableFunctionCallOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFunctionCallOperator(this.valueType, this.functionName, (ImmutableList<Expression>)this.args.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("functionName");
            }
            return "Cannot build FunctionCallOperator, some of required attributes are not set " + attributes;
        }
    }
}

