/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.VariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VariableReference", generator="Immutables")
@Immutable
public final class ImmutableVariableReference<T>
implements VariableReference<T> {
    private final ValueType valueType;
    private final ItemId itemId;

    private ImmutableVariableReference(ItemId itemId, ValueType valueType) {
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
    }

    private ImmutableVariableReference(ImmutableVariableReference<T> original, ValueType valueType, ItemId itemId) {
        this.valueType = valueType;
        this.itemId = itemId;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ItemId getItemId() {
        return this.itemId;
    }

    public final ImmutableVariableReference<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableVariableReference<T>(this, newValue, this.itemId);
    }

    public final ImmutableVariableReference<T> withItemId(ItemId value) {
        if (this.itemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemId");
        return new ImmutableVariableReference<T>(this, this.valueType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariableReference && this.equalTo((ImmutableVariableReference)another);
    }

    private boolean equalTo(ImmutableVariableReference<?> another) {
        return this.valueType.equals(another.valueType) && this.itemId.equals(another.itemId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.itemId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VariableReference").omitNullValues().add("valueType", (Object)this.valueType).add("itemId", (Object)this.itemId).toString();
    }

    public static <T> ImmutableVariableReference<T> of(ItemId itemId, ValueType valueType) {
        return new ImmutableVariableReference<T>(itemId, valueType);
    }

    public static <T> ImmutableVariableReference<T> copyOf(VariableReference<T> instance) {
        if (instance instanceof ImmutableVariableReference) {
            return (ImmutableVariableReference)instance;
        }
        return ImmutableVariableReference.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="VariableReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE_TYPE = 1L;
        private static final long INIT_BIT_ITEM_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private ValueType valueType;
        @Nullable
        private ItemId itemId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(VariableReference<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Expression instance;
            if (object instanceof VariableReference) {
                instance = (VariableReference)object;
                this.itemId(instance.getItemId());
            }
            if (object instanceof Expression) {
                instance = (Expression)object;
                this.valueType(instance.getValueType());
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> itemId(ItemId itemId) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableVariableReference<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVariableReference(null, this.valueType, this.itemId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("itemId");
            }
            return "Cannot build VariableReference, some of required attributes are not set " + attributes;
        }
    }
}

