/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.expr.arith.ImmutableConcatOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.ImmutableFormatOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableLocalizedLabelOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableToLowerCaseOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableToStringOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableToUpperCaseOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableValueSetEntryToStringOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.expr.arith.VariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Label;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableValueSetId;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@Value.Immutable
public interface LocalizedLabelOperator
extends Expression {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\{([\\w]*?)(:.*?)?}");

    public static LocalizedLabelOperator createLocalizedLabelOperator(@Nonnull ProgramBuilder programBuilder, @Nonnull Label label) {
        HashMap value = Maps.newHashMap();
        label.getLabels().forEach((key, labelString) -> {
            int i = 0;
            Matcher matcher = EXPRESSION_PATTERN.matcher((CharSequence)labelString);
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            while (matcher.find()) {
                expressions.add(ImmutableConstant.builder().value(labelString.substring(i, matcher.start())).valueType(ValueType.STRING).build());
                if (matcher.group(1) == null) {
                    expressions.add(ImmutableConstant.builder().value(matcher.group(0)).valueType(ValueType.STRING).build());
                } else {
                    String itemId = matcher.group(1);
                    VariableReference<?> variableReference = Operators.var(itemId, ValueType.STRING);
                    String format = matcher.group(2);
                    if (StringUtils.isNotBlank((CharSequence)format)) {
                        switch (format = format.substring(1)) {
                            case "key": {
                                expressions.add(ImmutableToStringOperator.of(variableReference));
                                break;
                            }
                            case "lowercase": {
                                expressions.add(ImmutableToLowerCaseOperator.lowerCaseOf(LocalizedLabelOperator.toStringExpression(programBuilder, IdUtils.toId(itemId), variableReference)));
                                break;
                            }
                            case "uppercase": {
                                expressions.add(ImmutableToUpperCaseOperator.upperCaseOf(LocalizedLabelOperator.toStringExpression(programBuilder, IdUtils.toId(itemId), variableReference)));
                                break;
                            }
                            default: {
                                expressions.add(ImmutableFormatOperator.of(variableReference, format));
                                break;
                            }
                        }
                    } else {
                        expressions.add(LocalizedLabelOperator.toStringExpression(programBuilder, IdUtils.toId(itemId), variableReference));
                    }
                }
                i = matcher.end();
            }
            String ending = labelString.substring(i);
            if (StringUtils.isNotEmpty((CharSequence)ending)) {
                expressions.add(ImmutableConstant.builder().value(ending).valueType(ValueType.STRING).build());
            }
            if (!expressions.isEmpty()) {
                value.put(key, expressions.size() > 1 ? ImmutableConcatOperator.builder().addAllExpressions(expressions).build() : (Expression)expressions.iterator().next());
            }
        });
        return ImmutableLocalizedLabelOperator.of(value);
    }

    public static Expression toStringExpression(@Nonnull ProgramBuilder programBuilder, ItemId itemId, VariableReference variableReference) {
        return programBuilder.findValueSetIdForItem(itemId).map(valueSetId -> ImmutableValueSetEntryToStringOperator.of(ImmutableValueSetId.of(valueSetId), variableReference)).orElseGet(() -> ImmutableToStringOperator.of(variableReference));
    }

    @Nonnull
    @Value.Parameter
    public Map<String, Expression> getValue();

    @Override
    default public String eval(@Nonnull EvalContext evalContext) {
        Expression expression = this.getValue().get(evalContext.getLanguage());
        if (expression == null) {
            return null;
        }
        return (String)expression.eval(evalContext);
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getValue().values().stream().map(Expression::getEvalRequiredConditions).reduce(Sets::union).orElse(Collections.emptySet());
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.STRING;
    }
}

