/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.UpdateValueSetCommand;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateValueSetCommand", generator="Immutables")
@Immutable
public final class ImmutableUpdateValueSetCommand
implements UpdateValueSetCommand {
    private final ImmutableList<Trigger<ValueSetState>> triggers;
    private final ValueSetId targetId;
    private final ImmutableList<Value<ValueSet.Entry>> entries;

    private ImmutableUpdateValueSetCommand(ValueSetId targetId, Iterable<? extends Value<ValueSet.Entry>> entries, Iterable<? extends Trigger<ValueSetState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.entries = ImmutableList.copyOf(entries);
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableUpdateValueSetCommand(ImmutableUpdateValueSetCommand original, ImmutableList<Trigger<ValueSetState>> triggers, ValueSetId targetId, ImmutableList<Value<ValueSet.Entry>> entries) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.entries = entries;
    }

    @Override
    public ImmutableList<Trigger<ValueSetState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ValueSetId getTargetId() {
        return this.targetId;
    }

    public ImmutableList<Value<ValueSet.Entry>> getEntries() {
        return this.entries;
    }

    @SafeVarargs
    public final ImmutableUpdateValueSetCommand withTriggers(Trigger<ValueSetState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUpdateValueSetCommand(this, (ImmutableList<Trigger<ValueSetState>>)newValue, this.targetId, this.entries);
    }

    public final ImmutableUpdateValueSetCommand withTriggers(Iterable<? extends Trigger<ValueSetState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUpdateValueSetCommand(this, (ImmutableList<Trigger<ValueSetState>>)newValue, this.targetId, this.entries);
    }

    public final ImmutableUpdateValueSetCommand withTargetId(ValueSetId value) {
        if (this.targetId == value) {
            return this;
        }
        ValueSetId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableUpdateValueSetCommand(this, this.triggers, newValue, this.entries);
    }

    @SafeVarargs
    public final ImmutableUpdateValueSetCommand withEntries(Value<ValueSet.Entry> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUpdateValueSetCommand(this, this.triggers, this.targetId, (ImmutableList<Value<ValueSet.Entry>>)newValue);
    }

    public final ImmutableUpdateValueSetCommand withEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
        if (this.entries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUpdateValueSetCommand(this, this.triggers, this.targetId, (ImmutableList<Value<ValueSet.Entry>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateValueSetCommand && this.equalTo((ImmutableUpdateValueSetCommand)another);
    }

    private boolean equalTo(ImmutableUpdateValueSetCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UpdateValueSetCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("entries", this.entries).toString();
    }

    public static ImmutableUpdateValueSetCommand of(ValueSetId targetId, List<Value<ValueSet.Entry>> entries, List<Trigger<ValueSetState>> triggers) {
        return ImmutableUpdateValueSetCommand.of(targetId, entries, triggers);
    }

    public static ImmutableUpdateValueSetCommand of(ValueSetId targetId, Iterable<? extends Value<ValueSet.Entry>> entries, Iterable<? extends Trigger<ValueSetState>> triggers) {
        return new ImmutableUpdateValueSetCommand(targetId, entries, triggers);
    }

    public static ImmutableUpdateValueSetCommand copyOf(UpdateValueSetCommand instance) {
        if (instance instanceof ImmutableUpdateValueSetCommand) {
            return (ImmutableUpdateValueSetCommand)instance;
        }
        return ImmutableUpdateValueSetCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateValueSetCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ValueSetState>> triggers = ImmutableList.builder();
        @Nullable
        private ValueSetId targetId;
        private ImmutableList.Builder<Value<ValueSet.Entry>> entries = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateValueSetCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ValueSetId)instance.getTargetId());
            this.addAllEntries(instance.getEntries());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ValueSetState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ValueSetState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ValueSetState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ValueSetState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ValueSetId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(Value<ValueSet.Entry> element) {
            this.entries.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addEntries(Value<ValueSet.Entry> ... elements) {
            this.entries.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends Value<ValueSet.Entry>> elements) {
            this.entries = ImmutableList.builder();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
            this.entries.addAll(elements);
            return this;
        }

        public ImmutableUpdateValueSetCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateValueSetCommand(null, (ImmutableList<Trigger<ValueSetState>>)this.triggers.build(), this.targetId, (ImmutableList<Value<ValueSet.Entry>>)this.entries.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build UpdateValueSetCommand, some of required attributes are not set " + attributes;
        }
    }
}

