/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.Builder;
import io.dialob.session.engine.program.BuilderParent;
import io.dialob.session.engine.program.GroupBuilder;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.expr.arith.BooleanOperators;
import io.dialob.session.engine.program.expr.arith.LocalizedLabelOperator;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableConditionalValue;
import io.dialob.session.engine.program.model.ImmutableConstantValue;
import io.dialob.session.engine.program.model.ImmutableLabel;
import io.dialob.session.engine.program.model.Label;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableItemIdPartial;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.spi.AliasesProvider;
import io.dialob.session.engine.spi.ExpressionCompiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemBuilder<T extends AbstractItemBuilder<T, P>, P extends ExpressionCompiler & BuilderParent>
implements Builder<P>,
AliasesProvider {
    public static final ImmutableLabel EMPTY_LABEL = ImmutableLabel.builder().build();
    private final ProgramBuilder programBuilder;
    private final GroupBuilder hoistingGroupBuilder;
    private final P parent;
    private final String id;
    private ItemId itemId;
    List<Value<String>> classNames = new ArrayList<Value<String>>();
    protected Label label = EMPTY_LABEL;
    protected Label description = EMPTY_LABEL;
    protected Expression activeWhen;
    protected Map<String, ? extends Object> props = null;

    public AbstractItemBuilder(ProgramBuilder programBuilder, P parent, GroupBuilder hoistingGroupBuilder, @Nonnull String id) {
        this.programBuilder = programBuilder;
        this.parent = parent;
        this.hoistingGroupBuilder = hoistingGroupBuilder;
        this.id = Objects.requireNonNull(id);
        this.setActiveWhen(BooleanOperators.TRUE);
    }

    protected ProgramBuilder getProgramBuilder() {
        return this.programBuilder;
    }

    P getParent() {
        return this.parent;
    }

    boolean compileExpression(@Nonnull String expression, @Nonnull Consumer<Expression> expressionConsumer, FormValidationError.Type type, Optional<Integer> index) {
        return this.compileExpression(expression, this, expressionConsumer, type, index);
    }

    boolean compileExpression(@Nonnull String expression, @Nonnull AliasesProvider aliasesProvider, @Nonnull Consumer<Expression> expressionConsumer, @Nonnull FormValidationError.Type type, Optional<Integer> index) {
        return this.getParent().compile(this.getId(), expression, aliasesProvider, expressionConsumer, type, index);
    }

    public T addClassname(@Nonnull String className) {
        return this.addClassname(ImmutableConstantValue.builder().value(className).valueType(ValueType.STRING).build());
    }

    public T addClassname(String when, @Nonnull String className) {
        if (!this.compileExpression(when, expression -> this.addClassname(ImmutableConditionalValue.builder().when((Expression)expression).value(className).valueType(ValueType.STRING).build()), FormValidationError.Type.CLASSNAME, Optional.empty())) {
            this.addClassname(className);
        }
        return (T)this;
    }

    private T addClassname(Value<String> value) {
        this.classNames.add(value);
        return (T)this;
    }

    public T setLabel(Map<String, String> label) {
        this.label = ImmutableLabel.builder().putAllLabels(label).build();
        return (T)this;
    }

    public T setLabel(String language, String label) {
        this.label = ImmutableLabel.builder().from(this.label).putLabels(language, label).build();
        return (T)this;
    }

    public T setDescription(Map<String, String> description) {
        this.description = ImmutableLabel.builder().putAllLabels(description).build();
        return (T)this;
    }

    public T setDescription(String language, String description) {
        this.description = ImmutableLabel.builder().from(this.description).putLabels(language, description).build();
        return (T)this;
    }

    public T setActiveWhen(String activeWhen) {
        if (StringUtils.isNotBlank((CharSequence)activeWhen)) {
            this.compileExpression(activeWhen, this::setActiveWhen, this.getActiveWhenExpressionErrorType(), this.getIndex());
        }
        return (T)this;
    }

    protected Optional<Integer> getIndex() {
        return Optional.empty();
    }

    @NotNull
    protected FormValidationError.Type getActiveWhenExpressionErrorType() {
        return FormValidationError.Type.VISIBILITY;
    }

    public T setProps(Map<String, Object> props) {
        this.props = props;
        return (T)this;
    }

    @Override
    public Map<String, ItemId> getAliases() {
        return Collections.emptyMap();
    }

    protected T setActiveWhen(Expression activeWhen) {
        this.activeWhen = activeWhen;
        return (T)this;
    }

    protected void requireBooleanExpression(Expression expression, FormValidationError.Type type, Consumer<FormValidationError> errorConsumer) {
        if (expression != null && expression.getValueType() != ValueType.BOOLEAN) {
            errorConsumer.accept((FormValidationError)ImmutableFormValidationError.builder().itemId(this.id).message("BOOLEAN_EXPRESSION_EXPECTED").type(type).index(this.getIndex()).build());
        }
    }

    public T addClassnames(List<String> classNames) {
        classNames.stream().map(className -> ImmutableConstantValue.builder().value((String)className).valueType(ValueType.STRING).build()).forEach(this.classNames::add);
        return (T)this;
    }

    @Override
    public P build() {
        this.doBuild();
        return this.parent;
    }

    protected void doBuild() {
    }

    protected void beforeExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
    }

    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        Objects.requireNonNull(this.id, "id may not be null");
        this.requireBooleanExpression(this.activeWhen, this.getActiveWhenExpressionErrorType(), errorConsumer);
    }

    @Nonnull
    public ItemId getId() {
        if (this.itemId == null) {
            this.setupId();
        }
        return Objects.requireNonNull(this.itemId);
    }

    String getIdStr() {
        return this.id;
    }

    void setupId() {
        this.itemId = this.findHostingRowgroupId().map(hostingGroup -> ImmutableItemRef.of(this.id, Optional.of(ImmutableItemIdPartial.of(Optional.of(hostingGroup))))).orElse((ImmutableItemRef)IdUtils.toId(this.id));
    }

    public Optional<ValueType> getValueType() {
        return Optional.empty();
    }

    LocalizedLabelOperator createLabelOperator(Map<String, String> label) {
        return this.createLabelOperator(Label.createLabel(label));
    }

    LocalizedLabelOperator createLabelOperator(Label label) {
        return LocalizedLabelOperator.createLocalizedLabelOperator(this.getProgramBuilder(), label);
    }

    protected Optional<GroupBuilder> getHoistingGroup() {
        return Optional.ofNullable(this.hoistingGroupBuilder);
    }

    protected Optional<ItemId> findHostingRowgroupId() {
        return this.getHoistingGroup().map(groupBuilder -> groupBuilder.getType() == GroupBuilder.Type.ROWGROUP ? groupBuilder : null).map(AbstractItemBuilder::getId);
    }
}

