/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormValidationError;
import io.dialob.form.service.api.validation.FormValidator;
import io.dialob.session.engine.DialobProgramErrorsException;
import io.dialob.session.engine.DialobProgramFromFormCompiler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobFormValidator
implements FormValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobFormValidator.class);
    private final DialobProgramFromFormCompiler programFromFormCompiler;

    public DialobFormValidator(@Nonnull DialobProgramFromFormCompiler programFromFormCompiler) {
        this.programFromFormCompiler = programFromFormCompiler;
    }

    @Nonnull
    public List<FormValidationError> validate(@Nonnull Form form) {
        ArrayList<FormValidationError> result;
        block2: {
            result = new ArrayList<FormValidationError>();
            try {
                this.programFromFormCompiler.compileForm(form);
            }
            catch (DialobProgramErrorsException e) {
                List<FormValidationError> errors = e.getErrors();
                result.addAll(errors);
                if (!LOGGER.isDebugEnabled()) break block2;
                StringBuilder sb = new StringBuilder();
                sb.append("Form validation errors for: ").append(form.getId()).append("\n  ").append(errors.stream().map(error -> error.getItemId() + ": " + error.getMessage()).collect(Collectors.joining("\n  ")));
                LOGGER.debug(sb.toString());
            }
        }
        return result;
    }
}

