/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import com.google.common.collect.ImmutableMap;
import io.dialob.api.form.FormValidationError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.QuestionBuilder;
import io.dialob.session.engine.program.expr.arith.ImmutableIsActiveOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsDisabledOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableError;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ValidationBuilder
extends AbstractItemBuilder<ValidationBuilder, QuestionBuilder> {
    private final String errorCode;
    private Expression disabledExpression;
    private boolean prototype;
    private String when;

    public ValidationBuilder(QuestionBuilder questionBuilder, String errorCode) {
        super(questionBuilder.getProgramBuilder(), questionBuilder, questionBuilder.getHoistingGroup().orElse(null), IdUtils.toString(questionBuilder.getId()) + ":" + errorCode);
        this.errorCode = errorCode;
    }

    private ItemId getQuestionId() {
        return ((QuestionBuilder)this.getParent()).getId();
    }

    public ValidationBuilder setPrototype(boolean prototype) {
        this.prototype = prototype;
        return this;
    }

    @Override
    public ValidationBuilder setActiveWhen(@Nullable String when) {
        if (StringUtils.isBlank((CharSequence)when)) {
            this.when = null;
            return this;
        }
        this.when = when;
        ItemId questionId = ((QuestionBuilder)this.getParent()).getId();
        this.compileExpression(when, expression -> {
            this.activeWhen = expression.getValueType() == ValueType.BOOLEAN ? Operators.and(ImmutableIsActiveOperator.builder().itemId(questionId).build(), expression) : expression;
        }, this.getActiveWhenExpressionErrorType(), Optional.empty());
        this.disabledExpression = ImmutableIsDisabledOperator.builder().itemId(questionId).build();
        return this;
    }

    @Override
    public Map<String, ItemId> getAliases() {
        return ImmutableMap.builder().putAll(((QuestionBuilder)this.getParent()).getAliases()).put((Object)"answer", (Object)this.getQuestionId()).build();
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        this.requireBooleanExpression(this.activeWhen, this.getActiveWhenExpressionErrorType(), errorConsumer);
        if (this.when == null) {
            return;
        }
        ((QuestionBuilder)this.getParent()).addError(ImmutableError.builder().itemId(this.getQuestionId()).code(this.errorCode).isPrototype(this.prototype).validationExpression(this.activeWhen).disabledExpression(this.disabledExpression).label(this.createLabelOperator(this.label)).build());
    }

    @Override
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FormValidationError.Type getActiveWhenExpressionErrorType() {
        return FormValidationError.Type.VALIDATION;
    }
}

