/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.GroupBuilder;
import io.dialob.session.engine.program.HasDefaultValue;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.expr.arith.ImmutableContextVariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableVariableItem;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Optional;
import java.util.function.Consumer;

public class VariableBuilder
extends AbstractItemBuilder<GroupBuilder, ProgramBuilder>
implements HasDefaultValue {
    private Expression valueExpression;
    private Object defaultValue;
    private String type;
    private boolean context = false;
    private boolean published = false;

    VariableBuilder(ProgramBuilder programBuilder, String id) {
        super(programBuilder, programBuilder, null, id);
    }

    public VariableBuilder setValueExpression(String valueExpression) {
        if (valueExpression != null) {
            this.compileExpression(valueExpression, expression -> {
                this.valueExpression = expression;
            }, FormValidationError.Type.VARIABLE, Optional.empty());
        }
        return this;
    }

    public VariableBuilder setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public VariableBuilder setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public Optional<ValueType> getValueType() {
        if (this.context) {
            return Utils.mapQuestionTypeToValueType(this.type);
        }
        return Optional.ofNullable(this.valueExpression != null ? this.valueExpression.getValueType() : null);
    }

    public VariableBuilder setContext(Boolean context) {
        if (context != null) {
            this.context = context;
        }
        return this;
    }

    public VariableBuilder setPublished(Boolean published) {
        if (published != null) {
            this.published = published;
        }
        return this;
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        super.afterExpressionCompilation(errorConsumer);
        ItemId id = this.getId();
        if (this.context) {
            this.valueExpression = Utils.mapQuestionTypeToValueType(this.type).map(valueType -> ImmutableContextVariableReference.builder().itemId(id).valueType((ValueType)valueType).build()).orElse(null);
            if (this.valueExpression == null) {
                errorConsumer.accept((FormValidationError)ImmutableFormValidationError.builder().itemId(this.getIdStr()).message("CONTEXT_VARIABLE_UNDEFINED_TYPE").type(FormValidationError.Type.VARIABLE).build());
                return;
            }
        }
        if (this.valueExpression == null) {
            errorConsumer.accept((FormValidationError)ImmutableFormValidationError.builder().itemId(this.getIdStr()).message("RB_VARIABLE_NEEDS_EXPRESSION").type(FormValidationError.Type.VARIABLE).build());
            return;
        }
        Optional<Object> resolvedDefaultValue = this.getDefaultValue().map(value -> Utils.validateDefaultValue(IdUtils.toString(id), this.valueExpression.getValueType(), value, errorConsumer));
        this.getProgramBuilder().addItem(ImmutableVariableItem.builder().id(id).type(this.context ? "context" : "variable").isPrototype(false).isPublished(this.published).valueExpression(this.valueExpression).defaultValue(resolvedDefaultValue).build());
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }
}

