/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Value.Immutable
public interface ArrayReducerOperator<T>
extends Expression {
    public static final BinaryOperator<Object> ANSWER_COUNT = (result, element) -> {
        if (element != null) {
            return result == null ? 1 : (Integer)result + 1;
        }
        return result;
    };
    public static final BinaryOperator<Integer> INTEGER_SUM = (result, element) -> {
        if (element != null) {
            return result == null ? element : result + element;
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_SUM = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.add((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<Integer> INTEGER_MIN = (result, element) -> {
        if (element != null) {
            return result == null ? element : Math.min(result, element);
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_MIN = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.min((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<Integer> INTEGER_MAX = (result, element) -> {
        if (element != null) {
            return result == null ? element : Math.max(result, element);
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_MAX = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.max((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<Boolean> ANY = (result, element) -> {
        if (element != null) {
            return result == null ? element : result != false || element != false;
        }
        return result;
    };
    public static final BinaryOperator<Boolean> ALL = (result, element) -> {
        if (element != null) {
            return result == null ? element : result != false && element != false;
        }
        return result;
    };

    @Value.Parameter
    public BinaryOperator<T> getReducer();

    @Value.Parameter
    public Expression getArrayExpression();

    @Value.Default
    @Nullable
    default public Object getPlaceholderValue() {
        return null;
    }

    @Override
    @Nullable
    default public Object eval(@NotNull EvalContext evalContext) {
        List values = (List)this.getArrayExpression().eval(evalContext);
        return values.stream().filter(Objects::nonNull).reduce(this.getReducer()).orElse(this.getPlaceholderValue());
    }

    @Override
    @NotNull
    default public ValueType getValueType() {
        return this.getArrayExpression().getValueType().getItemValueType();
    }

    @Override
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getArrayExpression().getEvalRequiredConditions();
    }

    public static BinaryOperator<? extends Number> sumOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_SUM;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_SUM;
        }
        return null;
    }

    public static BinaryOperator<? extends Number> minOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_MIN;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_MIN;
        }
        return null;
    }

    public static BinaryOperator<? extends Number> maxOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_MAX;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_MAX;
        }
        return null;
    }

    public static BinaryOperator<Boolean> allOp(ValueType valueType) {
        if (valueType == ValueType.BOOLEAN) {
            return ALL;
        }
        return null;
    }

    public static BinaryOperator<Boolean> anyOp(ValueType valueType) {
        if (valueType == ValueType.BOOLEAN) {
            return ANY;
        }
        return null;
    }
}

