/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.math.BigDecimal;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface CoerceToDecimalOperator
extends Expression {
    @Value.Parameter
    public Expression getExpression();

    @Override
    default public BigDecimal eval(@Nonnull EvalContext context) {
        Object eval = this.getExpression().eval(context);
        if (eval == null) {
            return null;
        }
        if (eval instanceof BigDecimal) {
            return (BigDecimal)eval;
        }
        if (eval instanceof Double) {
            return BigDecimal.valueOf((Double)eval);
        }
        if (eval instanceof Number) {
            return BigDecimal.valueOf(((Number)eval).longValue());
        }
        if (eval instanceof String) {
            return new BigDecimal((String)eval);
        }
        throw new IllegalStateException("Cannot coerce " + eval + " to decimal");
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.DECIMAL;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getExpression().getEvalRequiredConditions();
    }
}

