/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.expr.arith.ArrayReducerOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ArrayReducerOperator", generator="Immutables")
@Immutable
public final class ImmutableArrayReducerOperator<T>
implements ArrayReducerOperator<T> {
    private final BinaryOperator<T> reducer;
    private final Expression arrayExpression;
    @Nullable
    private final Object placeholderValue;

    private ImmutableArrayReducerOperator(BinaryOperator<T> reducer, Expression arrayExpression) {
        this.reducer = Objects.requireNonNull(reducer, "reducer");
        this.arrayExpression = Objects.requireNonNull(arrayExpression, "arrayExpression");
        this.placeholderValue = ArrayReducerOperator.super.getPlaceholderValue();
    }

    private ImmutableArrayReducerOperator(Builder<T> builder) {
        this.reducer = builder.reducer;
        this.arrayExpression = builder.arrayExpression;
        this.placeholderValue = builder.placeholderValueIsSet() ? builder.placeholderValue : ArrayReducerOperator.super.getPlaceholderValue();
    }

    private ImmutableArrayReducerOperator(BinaryOperator<T> reducer, Expression arrayExpression, @Nullable Object placeholderValue) {
        this.reducer = reducer;
        this.arrayExpression = arrayExpression;
        this.placeholderValue = placeholderValue;
    }

    @Override
    public BinaryOperator<T> getReducer() {
        return this.reducer;
    }

    @Override
    public Expression getArrayExpression() {
        return this.arrayExpression;
    }

    @Override
    @Nullable
    public Object getPlaceholderValue() {
        return this.placeholderValue;
    }

    public final ImmutableArrayReducerOperator<T> withReducer(BinaryOperator<T> value) {
        if (this.reducer == value) {
            return this;
        }
        BinaryOperator<T> newValue = Objects.requireNonNull(value, "reducer");
        return new ImmutableArrayReducerOperator<T>(newValue, this.arrayExpression, this.placeholderValue);
    }

    public final ImmutableArrayReducerOperator<T> withArrayExpression(Expression value) {
        if (this.arrayExpression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "arrayExpression");
        return new ImmutableArrayReducerOperator<T>(this.reducer, newValue, this.placeholderValue);
    }

    public final ImmutableArrayReducerOperator<T> withPlaceholderValue(@Nullable Object value) {
        if (this.placeholderValue == value) {
            return this;
        }
        return new ImmutableArrayReducerOperator<T>(this.reducer, this.arrayExpression, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArrayReducerOperator && this.equalTo((ImmutableArrayReducerOperator)another);
    }

    private boolean equalTo(ImmutableArrayReducerOperator<?> another) {
        return this.reducer.equals(another.reducer) && this.arrayExpression.equals(another.arrayExpression) && Objects.equals(this.placeholderValue, another.placeholderValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reducer.hashCode();
        h += (h << 5) + this.arrayExpression.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholderValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArrayReducerOperator").omitNullValues().add("reducer", this.reducer).add("arrayExpression", (Object)this.arrayExpression).add("placeholderValue", this.placeholderValue).toString();
    }

    public static <T> ImmutableArrayReducerOperator<T> of(BinaryOperator<T> reducer, Expression arrayExpression) {
        return new ImmutableArrayReducerOperator<T>(reducer, arrayExpression);
    }

    public static <T> ImmutableArrayReducerOperator<T> copyOf(ArrayReducerOperator<T> instance) {
        if (instance instanceof ImmutableArrayReducerOperator) {
            return (ImmutableArrayReducerOperator)instance;
        }
        return ImmutableArrayReducerOperator.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ArrayReducerOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_REDUCER = 1L;
        private static final long INIT_BIT_ARRAY_EXPRESSION = 2L;
        private static final long OPT_BIT_PLACEHOLDER_VALUE = 1L;
        private long initBits = 3L;
        private long optBits;
        @javax.annotation.Nullable
        private BinaryOperator<T> reducer;
        @javax.annotation.Nullable
        private Expression arrayExpression;
        @javax.annotation.Nullable
        private Object placeholderValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ArrayReducerOperator<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.reducer(instance.getReducer());
            this.arrayExpression(instance.getArrayExpression());
            @Nullable Object placeholderValueValue = instance.getPlaceholderValue();
            if (placeholderValueValue != null) {
                this.placeholderValue(placeholderValueValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> reducer(BinaryOperator<T> reducer) {
            this.reducer = Objects.requireNonNull(reducer, "reducer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> arrayExpression(Expression arrayExpression) {
            this.arrayExpression = Objects.requireNonNull(arrayExpression, "arrayExpression");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> placeholderValue(@Nullable Object placeholderValue) {
            this.placeholderValue = placeholderValue;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableArrayReducerOperator<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArrayReducerOperator(this);
        }

        private boolean placeholderValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reducer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arrayExpression");
            }
            return "Cannot build ArrayReducerOperator, some of required attributes are not set " + attributes;
        }
    }
}

