/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.expr.arith.EqOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EqOperator", generator="Immutables")
@Immutable
public final class ImmutableEqOperator<T>
implements EqOperator<T> {
    private final Expression lhs;
    private final Expression rhs;

    private ImmutableEqOperator(Expression lhs, Expression rhs) {
        this.lhs = Objects.requireNonNull(lhs, "lhs");
        this.rhs = Objects.requireNonNull(rhs, "rhs");
    }

    private ImmutableEqOperator(ImmutableEqOperator<T> original, Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Expression getLhs() {
        return this.lhs;
    }

    @Override
    public Expression getRhs() {
        return this.rhs;
    }

    public final ImmutableEqOperator<T> withLhs(Expression value) {
        if (this.lhs == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "lhs");
        return new ImmutableEqOperator<T>(this, newValue, this.rhs);
    }

    public final ImmutableEqOperator<T> withRhs(Expression value) {
        if (this.rhs == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "rhs");
        return new ImmutableEqOperator<T>(this, this.lhs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEqOperator && this.equalTo((ImmutableEqOperator)another);
    }

    private boolean equalTo(ImmutableEqOperator<?> another) {
        return this.lhs.equals(another.lhs) && this.rhs.equals(another.rhs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lhs.hashCode();
        h += (h << 5) + this.rhs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EqOperator").omitNullValues().add("lhs", (Object)this.lhs).add("rhs", (Object)this.rhs).toString();
    }

    public static <T> ImmutableEqOperator<T> of(Expression lhs, Expression rhs) {
        return new ImmutableEqOperator<T>(lhs, rhs);
    }

    public static <T> ImmutableEqOperator<T> copyOf(EqOperator<T> instance) {
        if (instance instanceof ImmutableEqOperator) {
            return (ImmutableEqOperator)instance;
        }
        return ImmutableEqOperator.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="EqOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_LHS = 1L;
        private static final long INIT_BIT_RHS = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression lhs;
        @Nullable
        private Expression rhs;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(EqOperator<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.lhs(instance.getLhs());
            this.rhs(instance.getRhs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> lhs(Expression lhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> rhs(Expression rhs) {
            this.rhs = Objects.requireNonNull(rhs, "rhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEqOperator<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEqOperator(null, this.lhs, this.rhs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lhs");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rhs");
            }
            return "Cannot build EqOperator, some of required attributes are not set " + attributes;
        }
    }
}

