/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.DisplayItem;
import io.dialob.session.engine.program.model.Error;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.FormItem;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.StructuralNode;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FormItem", generator="Immutables")
@Immutable
public final class ImmutableFormItem
implements FormItem {
    private final boolean isPrototype;
    private final ItemId id;
    private final String type;
    @javax.annotation.Nullable
    private final ValueType valueType;
    @javax.annotation.Nullable
    private final String valueSetId;
    @javax.annotation.Nullable
    private final Object defaultValue;
    @Nullable
    private final String view;
    @Nullable
    private final Map<String, Object> props;
    @javax.annotation.Nullable
    private final Expression className;
    @javax.annotation.Nullable
    private final Expression activeExpression;
    @javax.annotation.Nullable
    private final Expression requiredExpression;
    @javax.annotation.Nullable
    private final Expression disabledExpression;
    @javax.annotation.Nullable
    private final Expression labelExpression;
    @javax.annotation.Nullable
    private final Expression descriptionExpression;
    private final List<Error> errors;

    private ImmutableFormItem(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.valueType = builder.valueType;
        this.valueSetId = builder.valueSetId;
        this.defaultValue = builder.defaultValue;
        this.view = builder.view;
        this.props = builder.props == null ? null : ImmutableFormItem.createUnmodifiableMap(false, false, builder.props);
        this.className = builder.className;
        this.activeExpression = builder.activeExpression;
        this.requiredExpression = builder.requiredExpression;
        this.disabledExpression = builder.disabledExpression;
        this.labelExpression = builder.labelExpression;
        this.descriptionExpression = builder.descriptionExpression;
        this.errors = ImmutableFormItem.createUnmodifiableList(true, builder.errors);
        this.isPrototype = builder.isPrototypeIsSet() ? builder.isPrototype : FormItem.super.isPrototype();
    }

    private ImmutableFormItem(boolean isPrototype, ItemId id, String type, @javax.annotation.Nullable ValueType valueType, @javax.annotation.Nullable String valueSetId, @javax.annotation.Nullable Object defaultValue, @Nullable String view, @Nullable Map<String, Object> props, @javax.annotation.Nullable Expression className, @javax.annotation.Nullable Expression activeExpression, @javax.annotation.Nullable Expression requiredExpression, @javax.annotation.Nullable Expression disabledExpression, @javax.annotation.Nullable Expression labelExpression, @javax.annotation.Nullable Expression descriptionExpression, List<Error> errors) {
        this.isPrototype = isPrototype;
        this.id = id;
        this.type = type;
        this.valueType = valueType;
        this.valueSetId = valueSetId;
        this.defaultValue = defaultValue;
        this.view = view;
        this.props = props;
        this.className = className;
        this.activeExpression = activeExpression;
        this.requiredExpression = requiredExpression;
        this.disabledExpression = disabledExpression;
        this.labelExpression = labelExpression;
        this.descriptionExpression = descriptionExpression;
        this.errors = errors;
    }

    @Override
    public boolean isPrototype() {
        return this.isPrototype;
    }

    @Override
    public ItemId getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @javax.annotation.Nullable
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Optional<String> getValueSetId() {
        return Optional.ofNullable(this.valueSetId);
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    @Nullable
    public String getView() {
        return this.view;
    }

    @Override
    @Nullable
    public Map<String, Object> getProps() {
        return this.props;
    }

    @Override
    public Optional<Expression> getClassName() {
        return Optional.ofNullable(this.className);
    }

    @Override
    public Optional<Expression> getActiveExpression() {
        return Optional.ofNullable(this.activeExpression);
    }

    @Override
    public Optional<Expression> getRequiredExpression() {
        return Optional.ofNullable(this.requiredExpression);
    }

    @Override
    public Optional<Expression> getDisabledExpression() {
        return Optional.ofNullable(this.disabledExpression);
    }

    @Override
    public Optional<Expression> getLabelExpression() {
        return Optional.ofNullable(this.labelExpression);
    }

    @Override
    public Optional<Expression> getDescriptionExpression() {
        return Optional.ofNullable(this.descriptionExpression);
    }

    @Override
    public List<Error> getErrors() {
        return this.errors;
    }

    public final ImmutableFormItem withIsPrototype(boolean value) {
        if (this.isPrototype == value) {
            return this;
        }
        return new ImmutableFormItem(value, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withId(ItemId value) {
        if (this.id == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableFormItem(this.isPrototype, newValue, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, newValue, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withValueType(@javax.annotation.Nullable ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, value, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withValueSetId(String value) {
        String newValue = Objects.requireNonNull(value, "valueSetId");
        if (Objects.equals(this.valueSetId, newValue)) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, newValue, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withValueSetId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.valueSetId, value)) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, value, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withDefaultValue(Object value) {
        Object newValue = Objects.requireNonNull(value, "defaultValue");
        if (this.defaultValue == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, newValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withDefaultValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.defaultValue == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, value, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withView(@Nullable String value) {
        if (Objects.equals(this.view, value)) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, value, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withProps(@Nullable Map<String, ? extends Object> entries) {
        if (this.props == entries) {
            return this;
        }
        @Nullable Map<String, Object> newValue = entries == null ? null : ImmutableFormItem.createUnmodifiableMap(false, false, entries);
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, newValue, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withClassName(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "className");
        if (this.className == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, newValue, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withClassName(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.className == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, value, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withActiveExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "activeExpression");
        if (this.activeExpression == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, newValue, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withActiveExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.activeExpression == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, value, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withRequiredExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "requiredExpression");
        if (this.requiredExpression == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, newValue, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withRequiredExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.requiredExpression == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, value, this.disabledExpression, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withDisabledExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "disabledExpression");
        if (this.disabledExpression == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, newValue, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withDisabledExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.disabledExpression == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, value, this.labelExpression, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withLabelExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "labelExpression");
        if (this.labelExpression == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, newValue, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withLabelExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.labelExpression == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, value, this.descriptionExpression, this.errors);
    }

    public final ImmutableFormItem withDescriptionExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "descriptionExpression");
        if (this.descriptionExpression == newValue) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, newValue, this.errors);
    }

    public final ImmutableFormItem withDescriptionExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.descriptionExpression == value) {
            return this;
        }
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, value, this.errors);
    }

    public final ImmutableFormItem withErrors(Error ... elements) {
        List<Error> newValue = ImmutableFormItem.createUnmodifiableList(false, ImmutableFormItem.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, newValue);
    }

    public final ImmutableFormItem withErrors(Iterable<? extends Error> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<Error> newValue = ImmutableFormItem.createUnmodifiableList(false, ImmutableFormItem.createSafeList(elements, true, false));
        return new ImmutableFormItem(this.isPrototype, this.id, this.type, this.valueType, this.valueSetId, this.defaultValue, this.view, this.props, this.className, this.activeExpression, this.requiredExpression, this.disabledExpression, this.labelExpression, this.descriptionExpression, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormItem && this.equalTo((ImmutableFormItem)another);
    }

    private boolean equalTo(ImmutableFormItem another) {
        return this.isPrototype == another.isPrototype && this.id.equals(another.id) && this.type.equals(another.type) && Objects.equals(this.valueType, another.valueType) && Objects.equals(this.valueSetId, another.valueSetId) && Objects.equals(this.defaultValue, another.defaultValue) && Objects.equals(this.view, another.view) && Objects.equals(this.props, another.props) && Objects.equals(this.className, another.className) && Objects.equals(this.activeExpression, another.activeExpression) && Objects.equals(this.requiredExpression, another.requiredExpression) && Objects.equals(this.disabledExpression, another.disabledExpression) && Objects.equals(this.labelExpression, another.labelExpression) && Objects.equals(this.descriptionExpression, another.descriptionExpression) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isPrototype);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.valueType);
        h += (h << 5) + Objects.hashCode(this.valueSetId);
        h += (h << 5) + Objects.hashCode(this.defaultValue);
        h += (h << 5) + Objects.hashCode(this.view);
        h += (h << 5) + Objects.hashCode(this.props);
        h += (h << 5) + Objects.hashCode(this.className);
        h += (h << 5) + Objects.hashCode(this.activeExpression);
        h += (h << 5) + Objects.hashCode(this.requiredExpression);
        h += (h << 5) + Objects.hashCode(this.disabledExpression);
        h += (h << 5) + Objects.hashCode(this.labelExpression);
        h += (h << 5) + Objects.hashCode(this.descriptionExpression);
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FormItem{");
        builder.append("isPrototype=").append(this.isPrototype);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.valueType != null) {
            builder.append(", ");
            builder.append("valueType=").append(this.valueType);
        }
        if (this.valueSetId != null) {
            builder.append(", ");
            builder.append("valueSetId=").append(this.valueSetId);
        }
        if (this.defaultValue != null) {
            builder.append(", ");
            builder.append("defaultValue=").append(this.defaultValue);
        }
        if (this.view != null) {
            builder.append(", ");
            builder.append("view=").append(this.view);
        }
        if (this.props != null) {
            builder.append(", ");
            builder.append("props=").append(this.props);
        }
        if (this.className != null) {
            builder.append(", ");
            builder.append("className=").append(this.className);
        }
        if (this.activeExpression != null) {
            builder.append(", ");
            builder.append("activeExpression=").append(this.activeExpression);
        }
        if (this.requiredExpression != null) {
            builder.append(", ");
            builder.append("requiredExpression=").append(this.requiredExpression);
        }
        if (this.disabledExpression != null) {
            builder.append(", ");
            builder.append("disabledExpression=").append(this.disabledExpression);
        }
        if (this.labelExpression != null) {
            builder.append(", ");
            builder.append("labelExpression=").append(this.labelExpression);
        }
        if (this.descriptionExpression != null) {
            builder.append(", ");
            builder.append("descriptionExpression=").append(this.descriptionExpression);
        }
        builder.append(", ");
        builder.append("errors=").append(this.errors);
        return builder.append("}").toString();
    }

    public static ImmutableFormItem copyOf(FormItem instance) {
        if (instance instanceof ImmutableFormItem) {
            return (ImmutableFormItem)instance;
        }
        return ImmutableFormItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="FormItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long OPT_BIT_IS_PROTOTYPE = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean isPrototype;
        @javax.annotation.Nullable
        private ItemId id;
        @javax.annotation.Nullable
        private String type;
        @javax.annotation.Nullable
        private ValueType valueType;
        @javax.annotation.Nullable
        private String valueSetId;
        @javax.annotation.Nullable
        private Object defaultValue;
        @javax.annotation.Nullable
        private String view;
        private Map<String, Object> props = null;
        @javax.annotation.Nullable
        private Expression className;
        @javax.annotation.Nullable
        private Expression activeExpression;
        @javax.annotation.Nullable
        private Expression requiredExpression;
        @javax.annotation.Nullable
        private Expression disabledExpression;
        @javax.annotation.Nullable
        private Expression labelExpression;
        @javax.annotation.Nullable
        private Expression descriptionExpression;
        private List<Error> errors = new ArrayList<Error>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DisplayItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Item instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StructuralNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FormItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StructuralNode instance;
            if (object instanceof DisplayItem) {
                Optional<Expression> descriptionExpressionOptional;
                Optional<Expression> labelExpressionOptional;
                Optional<Expression> disabledExpressionOptional;
                Optional<Expression> classNameOptional;
                Optional<Expression> requiredExpressionOptional;
                Optional<Expression> activeExpressionOptional;
                instance = (DisplayItem)object;
                @Nullable String viewValue = instance.getView();
                if (viewValue != null) {
                    this.view(viewValue);
                }
                if ((activeExpressionOptional = instance.getActiveExpression()).isPresent()) {
                    this.activeExpression(activeExpressionOptional);
                }
                if ((requiredExpressionOptional = instance.getRequiredExpression()).isPresent()) {
                    this.requiredExpression(requiredExpressionOptional);
                }
                if ((classNameOptional = instance.getClassName()).isPresent()) {
                    this.className(classNameOptional);
                }
                if ((disabledExpressionOptional = instance.getDisabledExpression()).isPresent()) {
                    this.disabledExpression(disabledExpressionOptional);
                }
                if ((labelExpressionOptional = instance.getLabelExpression()).isPresent()) {
                    this.labelExpression(labelExpressionOptional);
                }
                this.addAllErrors(instance.getErrors());
                @Nullable Map<String, Object> propsValue = instance.getProps();
                if (propsValue != null) {
                    this.putAllProps(propsValue);
                }
                if ((descriptionExpressionOptional = instance.getDescriptionExpression()).isPresent()) {
                    this.descriptionExpression(descriptionExpressionOptional);
                }
            }
            if (object instanceof Item) {
                ValueType valueTypeValue;
                Optional<String> valueSetIdOptional;
                instance = (Item)object;
                this.id(instance.getId());
                this.type(instance.getType());
                Optional<Object> defaultValueOptional = instance.getDefaultValue();
                if (defaultValueOptional.isPresent()) {
                    this.defaultValue(defaultValueOptional);
                }
                if ((valueSetIdOptional = instance.getValueSetId()).isPresent()) {
                    this.valueSetId(valueSetIdOptional);
                }
                if ((valueTypeValue = instance.getValueType()) != null) {
                    this.valueType(valueTypeValue);
                }
            }
            if (object instanceof StructuralNode) {
                instance = (StructuralNode)object;
                this.isPrototype(instance.isPrototype());
            }
        }

        @CanIgnoreReturnValue
        public final Builder isPrototype(boolean isPrototype) {
            this.isPrototype = isPrototype;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(ItemId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueType(@javax.annotation.Nullable ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(String valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(Optional<String> valueSetId) {
            this.valueSetId = valueSetId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(Object defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(Optional<? extends Object> defaultValue) {
            this.defaultValue = defaultValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder view(@Nullable String view) {
            this.view = view;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProps(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
            if (this.props == null) {
                this.props = new LinkedHashMap<String, Object>();
            }
            this.props.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProps(Map.Entry<String, ? extends Object> entry) {
            if (this.props == null) {
                this.props = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.props.put(k, v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder props(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.props = null;
                return this;
            }
            this.props = new LinkedHashMap<String, Object>();
            return this.putAllProps(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProps(Map<String, ? extends Object> entries) {
            if (this.props == null) {
                this.props = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.props.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(Expression className) {
            this.className = Objects.requireNonNull(className, "className");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(Optional<? extends Expression> className) {
            this.className = className.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder activeExpression(Expression activeExpression) {
            this.activeExpression = Objects.requireNonNull(activeExpression, "activeExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder activeExpression(Optional<? extends Expression> activeExpression) {
            this.activeExpression = activeExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requiredExpression(Expression requiredExpression) {
            this.requiredExpression = Objects.requireNonNull(requiredExpression, "requiredExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requiredExpression(Optional<? extends Expression> requiredExpression) {
            this.requiredExpression = requiredExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledExpression(Expression disabledExpression) {
            this.disabledExpression = Objects.requireNonNull(disabledExpression, "disabledExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledExpression(Optional<? extends Expression> disabledExpression) {
            this.disabledExpression = disabledExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder labelExpression(Expression labelExpression) {
            this.labelExpression = Objects.requireNonNull(labelExpression, "labelExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder labelExpression(Optional<? extends Expression> labelExpression) {
            this.labelExpression = labelExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder descriptionExpression(Expression descriptionExpression) {
            this.descriptionExpression = Objects.requireNonNull(descriptionExpression, "descriptionExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder descriptionExpression(Optional<? extends Expression> descriptionExpression) {
            this.descriptionExpression = descriptionExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(Error element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(Error ... elements) {
            for (Error element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errors(Iterable<? extends Error> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllErrors(Iterable<? extends Error> elements) {
            for (Error error : elements) {
                this.errors.add(Objects.requireNonNull(error, "errors element"));
            }
            return this;
        }

        public ImmutableFormItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormItem(this);
        }

        private boolean isPrototypeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build FormItem, some of required attributes are not set " + attributes;
        }
    }
}

