/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueSet", generator="Immutables")
@Immutable
public final class ImmutableValueSet
implements ValueSet {
    private final String id;
    private final ImmutableList<Value<ValueSet.Entry>> entries;

    private ImmutableValueSet(String id, ImmutableList<Value<ValueSet.Entry>> entries) {
        this.id = id;
        this.entries = entries;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ImmutableList<Value<ValueSet.Entry>> getEntries() {
        return this.entries;
    }

    public final ImmutableValueSet withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableValueSet(newValue, this.entries);
    }

    @SafeVarargs
    public final ImmutableValueSet withEntries(Value<ValueSet.Entry> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableValueSet(this.id, (ImmutableList<Value<ValueSet.Entry>>)newValue);
    }

    public final ImmutableValueSet withEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
        if (this.entries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableValueSet(this.id, (ImmutableList<Value<ValueSet.Entry>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSet && this.equalTo((ImmutableValueSet)another);
    }

    private boolean equalTo(ImmutableValueSet another) {
        return this.id.equals(another.id) && this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSet").omitNullValues().add("id", (Object)this.id).add("entries", this.entries).toString();
    }

    public static ImmutableValueSet copyOf(ValueSet instance) {
        if (instance instanceof ImmutableValueSet) {
            return (ImmutableValueSet)instance;
        }
        return ImmutableValueSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckReturnValue
    @Generated(from="ValueSet.Entry", generator="Immutables")
    @Immutable
    public static final class Entry
    implements ValueSet.Entry {
        private final String key;
        private final Expression label;

        private Entry(String key, Expression label) {
            this.key = key;
            this.label = label;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Expression getLabel() {
            return this.label;
        }

        public final Entry withKey(String value) {
            String newValue = Objects.requireNonNull(value, "key");
            if (this.key.equals(newValue)) {
                return this;
            }
            return new Entry(newValue, this.label);
        }

        public final Entry withLabel(Expression value) {
            if (this.label == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "label");
            return new Entry(this.key, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Entry && this.equalTo((Entry)another);
        }

        private boolean equalTo(Entry another) {
            return this.key.equals(another.key) && this.label.equals(another.label);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.label.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Entry").omitNullValues().add("key", (Object)this.key).add("label", (Object)this.label).toString();
        }

        public static Entry copyOf(ValueSet.Entry instance) {
            if (instance instanceof Entry) {
                return (Entry)instance;
            }
            return Entry.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="ValueSet.Entry", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_KEY = 1L;
            private static final long INIT_BIT_LABEL = 2L;
            private long initBits = 3L;
            @Nullable
            private String key;
            @Nullable
            private Expression label;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(ValueSet.Entry instance) {
                Objects.requireNonNull(instance, "instance");
                this.key(instance.getKey());
                this.label(instance.getLabel());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder key(String key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder label(Expression label) {
                this.label = Objects.requireNonNull(label, "label");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Entry build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Entry(this.key, this.label);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("label");
                }
                return "Cannot build Entry, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="ValueSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableList.Builder<Value<ValueSet.Entry>> entries = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.addAllEntries(instance.getEntries());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(Value<ValueSet.Entry> element) {
            this.entries.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addEntries(Value<ValueSet.Entry> ... elements) {
            this.entries.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends Value<ValueSet.Entry>> elements) {
            this.entries = ImmutableList.builder();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
            this.entries.addAll(elements);
            return this;
        }

        public ImmutableValueSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSet(this.id, (ImmutableList<Value<ValueSet.Entry>>)this.entries.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ValueSet, some of required attributes are not set " + attributes;
        }
    }
}

