/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ImmutableItemStates;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface CreateRowGroupItemsFromPrototypeCommand
extends SessionUpdateCommand,
UpdateCommand<ItemId, ItemStates> {
    @Value.Parameter
    public ItemId getItemPrototypeId();

    @Override
    @Nonnull
    default public ItemStates update(@Nonnull EvalContext context, @Nonnull ItemStates itemStates) {
        ItemState currentItemState = itemStates.getItemStates().get(this.getTargetId());
        ImmutableSet currentItems = currentItemState != null ? Sets.newHashSet(currentItemState.getItems()) : ImmutableSet.of();
        Set originalItems = context.getOriginalItemState((ItemId)this.getTargetId()).map(state -> Sets.newHashSet(state.getItems())).orElse((Set)ImmutableSet.of());
        Sets.SetView newItems = Sets.difference((Set)currentItems, (Set)originalItems);
        Sets.SetView removedItems = Sets.difference((Set)originalItems, (Set)currentItems);
        if (newItems.isEmpty() && removedItems.isEmpty()) {
            return itemStates;
        }
        ImmutableItemStates.Builder builder = ImmutableItemStates.builder().from(itemStates).itemStates(itemStates.getItemStates().values().stream().filter(item -> !removedItems.contains((Object)item.getId())).collect(Collectors.toMap(itemState -> Objects.requireNonNull(itemState.getId()), item -> item))).errorStates(itemStates.getErrorStates().values().stream().filter(errorState -> !removedItems.contains((Object)errorState.getId().getItemId())).collect(Collectors.toMap(errorState -> Objects.requireNonNull(errorState.getId()), errorState -> errorState)));
        newItems.stream().flatMap(itemId -> context.findPrototype((ItemId)itemId).map(prototype -> prototype.withId((ItemId)itemId)).stream()).forEach(itemState -> builder.putItemStates(itemState.getId(), (ItemState)itemState));
        newItems.stream().flatMap(itemId -> context.findErrorPrototypes((ItemId)itemId).map(prototype -> prototype.withErrorId(prototype.getId().withItemId((ItemId)itemId)))).forEach(errorState -> builder.putErrorStates(errorState.getId(), (ErrorState)errorState));
        return builder.build();
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEventMatchers() {
        return ImmutableSet.of((Object)EventMatchers.whenRowGroupItemsInit(this.getItemPrototypeId()), (Object)EventMatchers.whenItemRemoved(this.getItemPrototypeId()));
    }
}

