/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.CreateRowGroupFromPrototypeCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateRowGroupFromPrototypeCommand", generator="Immutables")
@Immutable
public final class ImmutableCreateRowGroupFromPrototypeCommand
implements CreateRowGroupFromPrototypeCommand {
    private final ImmutableList<Trigger<ItemStates>> triggers;
    private final ItemId itemPrototypeId;

    private ImmutableCreateRowGroupFromPrototypeCommand(ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
        this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableCreateRowGroupFromPrototypeCommand(ImmutableCreateRowGroupFromPrototypeCommand original, ImmutableList<Trigger<ItemStates>> triggers, ItemId itemPrototypeId) {
        this.triggers = triggers;
        this.itemPrototypeId = itemPrototypeId;
    }

    @Override
    public ImmutableList<Trigger<ItemStates>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getItemPrototypeId() {
        return this.itemPrototypeId;
    }

    @SafeVarargs
    public final ImmutableCreateRowGroupFromPrototypeCommand withTriggers(Trigger<ItemStates> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateRowGroupFromPrototypeCommand(this, (ImmutableList<Trigger<ItemStates>>)newValue, this.itemPrototypeId);
    }

    public final ImmutableCreateRowGroupFromPrototypeCommand withTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateRowGroupFromPrototypeCommand(this, (ImmutableList<Trigger<ItemStates>>)newValue, this.itemPrototypeId);
    }

    public final ImmutableCreateRowGroupFromPrototypeCommand withItemPrototypeId(ItemId value) {
        if (this.itemPrototypeId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemPrototypeId");
        return new ImmutableCreateRowGroupFromPrototypeCommand(this, this.triggers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateRowGroupFromPrototypeCommand && this.equalTo((ImmutableCreateRowGroupFromPrototypeCommand)another);
    }

    private boolean equalTo(ImmutableCreateRowGroupFromPrototypeCommand another) {
        return this.triggers.equals(another.triggers) && this.itemPrototypeId.equals(another.itemPrototypeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.itemPrototypeId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateRowGroupFromPrototypeCommand").omitNullValues().add("triggers", this.triggers).add("itemPrototypeId", (Object)this.itemPrototypeId).toString();
    }

    public static ImmutableCreateRowGroupFromPrototypeCommand of(ItemId itemPrototypeId, List<Trigger<ItemStates>> triggers) {
        return ImmutableCreateRowGroupFromPrototypeCommand.of(itemPrototypeId, triggers);
    }

    public static ImmutableCreateRowGroupFromPrototypeCommand of(ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
        return new ImmutableCreateRowGroupFromPrototypeCommand(itemPrototypeId, triggers);
    }

    public static ImmutableCreateRowGroupFromPrototypeCommand copyOf(CreateRowGroupFromPrototypeCommand instance) {
        if (instance instanceof ImmutableCreateRowGroupFromPrototypeCommand) {
            return (ImmutableCreateRowGroupFromPrototypeCommand)instance;
        }
        return ImmutableCreateRowGroupFromPrototypeCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateRowGroupFromPrototypeCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ITEM_PROTOTYPE_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemStates>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId itemPrototypeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateRowGroupFromPrototypeCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.itemPrototypeId(instance.getItemPrototypeId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemStates> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemStates> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemStates>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemPrototypeId(ItemId itemPrototypeId) {
            this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCreateRowGroupFromPrototypeCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateRowGroupFromPrototypeCommand(null, (ImmutableList<Trigger<ItemStates>>)this.triggers.build(), this.itemPrototypeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("itemPrototypeId");
            }
            return "Cannot build CreateRowGroupFromPrototypeCommand, some of required attributes are not set " + attributes;
        }
    }
}

