/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.event.ItemAddedEvent;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ItemAddedEvent", generator="Immutables")
@Immutable
public final class ImmutableItemAddedEvent
implements ItemAddedEvent {
    private final ItemId addItemId;
    private final ItemId prototypeId;

    private ImmutableItemAddedEvent(ItemId addItemId, ItemId prototypeId) {
        this.addItemId = Objects.requireNonNull(addItemId, "addItemId");
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private ImmutableItemAddedEvent(ImmutableItemAddedEvent original, ItemId addItemId, ItemId prototypeId) {
        this.addItemId = addItemId;
        this.prototypeId = prototypeId;
    }

    @Override
    public ItemId getAddItemId() {
        return this.addItemId;
    }

    @Override
    public ItemId getPrototypeId() {
        return this.prototypeId;
    }

    public final ImmutableItemAddedEvent withAddItemId(ItemId value) {
        if (this.addItemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "addItemId");
        return new ImmutableItemAddedEvent(this, newValue, this.prototypeId);
    }

    public final ImmutableItemAddedEvent withPrototypeId(ItemId value) {
        if (this.prototypeId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "prototypeId");
        return new ImmutableItemAddedEvent(this, this.addItemId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemAddedEvent && this.equalTo((ImmutableItemAddedEvent)another);
    }

    private boolean equalTo(ImmutableItemAddedEvent another) {
        return this.addItemId.equals(another.addItemId) && this.prototypeId.equals(another.prototypeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.addItemId.hashCode();
        h += (h << 5) + this.prototypeId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemAddedEvent").omitNullValues().add("addItemId", (Object)this.addItemId).add("prototypeId", (Object)this.prototypeId).toString();
    }

    public static ImmutableItemAddedEvent of(ItemId addItemId, ItemId prototypeId) {
        return new ImmutableItemAddedEvent(addItemId, prototypeId);
    }

    public static ImmutableItemAddedEvent copyOf(ItemAddedEvent instance) {
        if (instance instanceof ImmutableItemAddedEvent) {
            return (ImmutableItemAddedEvent)instance;
        }
        return ImmutableItemAddedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ItemAddedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ADD_ITEM_ID = 1L;
        private static final long INIT_BIT_PROTOTYPE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private ItemId addItemId;
        @Nullable
        private ItemId prototypeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemAddedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.addItemId(instance.getAddItemId());
            this.prototypeId(instance.getPrototypeId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItemId(ItemId addItemId) {
            this.addItemId = Objects.requireNonNull(addItemId, "addItemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prototypeId(ItemId prototypeId) {
            this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableItemAddedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItemAddedEvent(null, this.addItemId, this.prototypeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("addItemId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("prototypeId");
            }
            return "Cannot build ItemAddedEvent, some of required attributes are not set " + attributes;
        }
    }
}

