/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableErrorId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.SessionObject;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ErrorState
implements SessionObject {
    private static final long serialVersionUID = -6652593868401573582L;
    private final ErrorId targetId;
    private String label;
    private boolean active;
    private boolean disabled;

    public UpdateBuilder update(EvalContext context) {
        return new UpdateBuilder();
    }

    public ErrorState(@Nonnull ItemId itemId, String code, String label) {
        this((ErrorId)ImmutableErrorId.of(itemId, code), label);
    }

    public ErrorState(@Nonnull ErrorId targetId, String label) {
        this.targetId = targetId;
        this.label = label;
    }

    public ErrorState(@Nonnull ErrorState errorState) {
        this(errorState.targetId, errorState);
    }

    public ErrorState(@Nonnull ErrorId targetId, @Nonnull ErrorState errorState) {
        this.targetId = targetId;
        this.label = errorState.label;
        this.active = errorState.active;
        this.disabled = errorState.disabled;
    }

    public ErrorState withErrorId(@Nonnull ErrorId targetId) {
        return new ErrorState(targetId, this);
    }

    public ErrorId getId() {
        return this.targetId;
    }

    public ItemId getItemId() {
        return this.targetId.getItemId();
    }

    public String getCode() {
        return this.targetId.getCode();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isDisplayItem() {
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        IdUtils.writeIdTo(this.targetId.getItemId(), output);
        if (this.targetId.getCode() == null) {
            output.writeBoolNoTag(false);
        } else {
            output.writeBoolNoTag(true);
            output.writeStringNoTag(this.targetId.getCode());
        }
        output.writeStringNoTag(this.label);
        output.writeBoolNoTag(this.active);
        output.writeBoolNoTag(this.disabled);
    }

    public static ErrorState readFrom(CodedInputStream input) throws IOException {
        ItemId itemId = Objects.requireNonNull(IdUtils.readIdFrom(input));
        String code = null;
        if (input.readBool()) {
            code = input.readString();
        }
        String label = input.readString();
        ErrorState state = new ErrorState(itemId, code, label);
        state.active = input.readBool();
        state.disabled = input.readBool();
        return state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorState)) {
            return false;
        }
        ErrorState other = (ErrorState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        ErrorId this$targetId = this.targetId;
        ErrorId other$targetId = other.targetId;
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        ErrorId $targetId = this.targetId;
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorState(targetId=" + this.targetId + ", label=" + this.getLabel() + ", active=" + this.isActive() + ", disabled=" + this.isDisabled() + ")";
    }

    public class UpdateBuilder {
        private ErrorState itemState;

        private ErrorState state() {
            if (this.itemState == null) {
                this.itemState = new ErrorState(ErrorState.this);
            }
            return this.itemState;
        }

        public UpdateBuilder setActive(boolean newActive) {
            if (ErrorState.this.active != newActive) {
                this.state().active = newActive;
            }
            return this;
        }

        public UpdateBuilder setDisabled(boolean newDisabled) {
            if (ErrorState.this.disabled != newDisabled) {
                this.state().disabled = newDisabled;
            }
            return this;
        }

        public UpdateBuilder setLabel(String newLabel) {
            if (!Objects.equals(newLabel, ErrorState.this.label)) {
                this.state().label = newLabel;
            }
            return this;
        }

        public ErrorState get() {
            if (this.itemState == null) {
                return ErrorState.this;
            }
            return this.itemState;
        }
    }
}

