/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ImmutableItemIdPartial;
import io.dialob.session.engine.session.model.ImmutableItemIndex;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemIdPartial;
import io.dialob.session.engine.session.model.ItemIndex;
import io.dialob.session.engine.session.model.ItemRef;
import io.dialob.session.engine.session.model.ValueSetId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class IdUtils {
    public static final ItemId QUESTIONNAIRE_ID = ImmutableItemRef.of("questionnaire", Optional.empty());

    public static String toString(ValueSetId valueSetId) {
        if (valueSetId == null) {
            return null;
        }
        return valueSetId.getValueSetId();
    }

    public static String toString(ItemId itemId) {
        if (itemId == null) {
            return null;
        }
        ArrayList idChain = Lists.newArrayList();
        Optional<ItemId> id = Optional.of(itemId);
        while (id.isPresent()) {
            itemId = id.get();
            if (itemId instanceof ErrorId) {
                return IdUtils.toString(((ErrorId)itemId).getItemId()) + ":" + ((ErrorId)itemId).getCode();
            }
            if (itemId instanceof ItemRef) {
                idChain.add(((ItemRef)itemId).getId());
            } else if (itemId instanceof ItemIndex) {
                idChain.add(((ItemIndex)itemId).getIndex().toString());
            } else if (itemId instanceof ItemIdPartial) {
                idChain.add("*");
            }
            id = itemId.getParent();
        }
        return StringUtils.join((Iterable)Lists.reverse((List)idChain), (String)".");
    }

    @Nullable
    public static ItemId toIdNullable(@Nullable String itemId) {
        if (itemId == null) {
            return null;
        }
        return IdUtils.toId(itemId);
    }

    @Nonnull
    public static ItemId toId(@Nullable String scopeId, @Nonnull String itemId) {
        if (StringUtils.isNotBlank((CharSequence)scopeId)) {
            return IdUtils.toId(scopeId + "." + itemId);
        }
        return IdUtils.toId(itemId);
    }

    @Nonnull
    public static ItemId toId(@Nonnull String itemId) {
        if ("questionnaire".equals(itemId)) {
            return QUESTIONNAIRE_ID;
        }
        String[] strings = itemId.split("\\.");
        ItemId id = null;
        for (String s : strings) {
            id = StringUtils.isNumeric((CharSequence)s) ? ImmutableItemIndex.of(Integer.parseInt(s), Optional.ofNullable(id)) : ("*".equals(s) ? ImmutableItemIdPartial.of(Optional.ofNullable(id)) : ImmutableItemRef.of(s, Optional.ofNullable(id)));
        }
        if (id == null) {
            throw new IllegalArgumentException(itemId + " is not valid id");
        }
        return id;
    }

    public static Collection<ItemId> toIds(Iterable<String> itemIds) {
        ArrayList<ItemId> itemIdList = new ArrayList<ItemId>();
        for (String id : itemIds) {
            itemIdList.add(IdUtils.toId(id));
        }
        return itemIdList;
    }

    public static ItemId withIndex(ItemId itemId, int index) {
        return itemId.withParent(ImmutableItemIndex.of(index, itemId.getParent().flatMap(ItemId::getParent)));
    }

    public static boolean matches(@Nonnull Optional<ItemId> itemIdLh, @Nonnull Optional<ItemId> itemIdRh) {
        if (itemIdLh.isPresent() == itemIdRh.isPresent()) {
            return itemIdLh.map(itemId -> IdUtils.matches(itemId, (ItemId)itemIdRh.get())).orElse(true);
        }
        return false;
    }

    public static boolean matches(@Nonnull ItemId itemIdLh, @Nonnull ItemId itemIdRh) {
        if (itemIdLh.equals(itemIdRh)) {
            return true;
        }
        if (Objects.equals(itemIdLh.getValue(), itemIdRh.getValue()) || itemIdLh instanceof ItemIdPartial || itemIdRh instanceof ItemIdPartial) {
            return IdUtils.matches(itemIdLh.getParent(), itemIdRh.getParent());
        }
        return false;
    }

    public static void writeIdTo(@Nullable ItemId id, CodedOutputStream output) throws IOException {
        if (id == null) {
            output.writeBoolNoTag(false);
            return;
        }
        output.writeBoolNoTag(true);
        if (id instanceof ItemRef) {
            ItemRef itemRef = (ItemRef)id;
            output.write((byte)1);
            output.writeStringNoTag(itemRef.getValue());
        } else if (id instanceof ItemIdPartial) {
            output.write((byte)2);
        } else if (id instanceof ItemIndex) {
            output.write((byte)3);
            ItemIndex itemRef = (ItemIndex)id;
            output.writeInt32NoTag(itemRef.getIndex().intValue());
        } else {
            throw new RuntimeException("unknown id type " + id);
        }
        IdUtils.writeIdTo(id.getParent().orElse(null), output);
    }

    @Nullable
    public static ItemId readIdFrom(CodedInputStream input) throws IOException {
        if (input.readBool()) {
            byte type = input.readRawByte();
            switch (type) {
                case 1: {
                    return ImmutableItemRef.of(input.readString(), Optional.ofNullable(IdUtils.readIdFrom(input)));
                }
                case 2: {
                    return ImmutableItemIdPartial.of(Optional.ofNullable(IdUtils.readIdFrom(input)));
                }
                case 3: {
                    return ImmutableItemIndex.of(input.readInt32(), Optional.ofNullable(IdUtils.readIdFrom(input)));
                }
            }
            throw new RuntimeException("unknown id type " + type);
        }
        return null;
    }
}

