/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import io.dialob.api.form.Form;
import io.dialob.db.spi.exceptions.DatabaseException;
import io.dialob.questionnaire.service.api.FormDataMissingException;
import io.dialob.questionnaire.service.api.InvalidFormException;
import io.dialob.questionnaire.service.api.session.FormFinder;
import io.dialob.session.engine.DialobProgramErrorsException;
import io.dialob.session.engine.DialobProgramFromFormCompiler;
import io.dialob.session.engine.DialobProgramService;
import io.dialob.session.engine.program.DialobProgram;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireDialobProgramService
implements DialobProgramService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnaireDialobProgramService.class);
    private final FormFinder formFinder;
    private final DialobProgramFromFormCompiler programFromFormCompiler;

    public static Builder newBuilder() {
        return new Builder();
    }

    QuestionnaireDialobProgramService(@Nonnull FormFinder formDatabase, @Nonnull DialobProgramFromFormCompiler programFromFormCompiler) {
        this.formFinder = formDatabase;
        this.programFromFormCompiler = programFromFormCompiler;
    }

    @Override
    @Nonnull
    public DialobProgram findByFormId(@Nonnull String formId) {
        return this.findByFormIdAndRev(formId, null);
    }

    @Override
    @Nonnull
    public DialobProgram findByFormIdAndRev(@Nonnull String formId, String formRev) {
        Form formDocument;
        try {
            formDocument = this.formFinder.findForm(formId, formRev);
        }
        catch (DatabaseException e) {
            LOGGER.debug("Could not load form {}: {}", (Object)formId, (Object)e.getMessage());
            throw new FormDataMissingException(formId, formRev);
        }
        try {
            LOGGER.info("Compiling form document {} rev {}", (Object)formId, (Object)formRev);
            return this.programFromFormCompiler.compileForm(formDocument);
        }
        catch (DialobProgramErrorsException e) {
            throw new InvalidFormException("Form is not usable", (Exception)e);
        }
    }

    public static class Builder {
        private FormFinder formDatabase;
        private DialobProgramFromFormCompiler programFromFormCompiler;

        private Builder() {
        }

        public Builder setFormDatabase(FormFinder formDatabase) {
            this.formDatabase = formDatabase;
            return this;
        }

        public Builder setProgramFromFormCompiler(DialobProgramFromFormCompiler programFromFormCompiler) {
            this.programFromFormCompiler = programFromFormCompiler;
            return this;
        }

        public QuestionnaireDialobProgramService build() {
            return new QuestionnaireDialobProgramService(this.formDatabase, this.programFromFormCompiler);
        }
    }
}

