/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.analyze.ValidateExpressionVisitor;
import io.dialob.rule.parser.api.RuleExpressionCompiler;
import io.dialob.rule.parser.api.RuleExpressionCompilerCallback;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.node.ASTVisitor;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DialobRuleExpressionCompiler
implements RuleExpressionCompiler {
    public boolean compile(@Nonnull String expression, @Nonnull VariableFinder variableFinder, @Nonnull RuleExpressionCompilerCallback compilationResultListener) {
        Objects.requireNonNull(expression, "expression may not be null");
        Objects.requireNonNull(variableFinder, "variableFinder may not be null");
        Objects.requireNonNull(compilationResultListener, "compilationResultListener may not be null");
        Expression expr = Expression.createExpression((VariableFinder)variableFinder, new HashMap(), (String)expression);
        if (!expr.getErrors().isEmpty()) {
            compilationResultListener.failed(expr.getErrors());
            return false;
        }
        ValidateExpressionVisitor validateExpressionVisitor = new ValidateExpressionVisitor();
        expr.getAst().accept((ASTVisitor)validateExpressionVisitor);
        if (validateExpressionVisitor.hasErrors()) {
            compilationResultListener.failed(validateExpressionVisitor.getErrors());
            return false;
        }
        return true;
    }

    @Nonnull
    public UnaryOperator<String> createIdRenamer(String oldId, String newId) {
        if (StringUtils.isBlank((CharSequence)oldId) || StringUtils.isBlank((CharSequence)newId)) {
            throw new IllegalArgumentException("old or newid may not be empty");
        }
        if (oldId.equals(newId)) {
            return expression -> expression;
        }
        return expression -> {
            if (expression == null) {
                return null;
            }
            Expression parsedExpression = Expression.createExpression((String)expression);
            if (parsedExpression.getAst() == null) {
                return expression;
            }
            return parsedExpression.renameId(oldId, newId).toString();
        };
    }
}

