/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.DialobSessionUpdateHook;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.OutputFormatter;
import io.dialob.session.engine.session.AsyncFunctionCall;
import io.dialob.session.engine.session.ImmutableAsyncFunctionCall;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableItemStates;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import io.dialob.session.engine.session.model.Scope;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DialobSessionEvalContext
implements EvalContext {
    private static final DialobSessionUpdateHook DEFAULT_DIALOB_SESSION_EVAL_HOOKS = (dialobSession, update, delegate) -> delegate.accept(update);
    private final DialobSessionEvalContext parent;
    private final Scope scope;
    private final FunctionRegistry functionRegistry;
    private final DialobSession dialobSession;
    private final Consumer<Event> updatesConsumer;
    private final ItemStates originalStates;
    private final Set<ItemId> updatedItemIds;
    private final Set<ErrorId> updatedErrorIds;
    private final Set<ValueSetId> updatedValueSetIds;
    private final Map<ItemId, AsyncFunctionCall> pendingUpdates;
    private final Clock clock;
    private final boolean activating;
    private boolean didComplete;
    private DialobSessionUpdateHook dialobSessionUpdateHook;
    private String originalLanguage;

    DialobSessionEvalContext(@Nonnull FunctionRegistry functionRegistry, @Nonnull DialobSession dialobSession, @Nonnull Consumer<Event> updatesConsumer, @Nonnull Clock clock, boolean activating, DialobSessionUpdateHook dialobSessionUpdateHook) {
        this.parent = null;
        this.scope = null;
        this.functionRegistry = functionRegistry;
        this.dialobSession = dialobSession;
        this.updatesConsumer = updatesConsumer;
        this.clock = clock;
        this.activating = activating;
        this.originalStates = ImmutableItemStates.builder().from(dialobSession).build();
        this.pendingUpdates = new HashMap<ItemId, AsyncFunctionCall>();
        this.updatedItemIds = new HashSet<ItemId>();
        this.updatedErrorIds = new HashSet<ErrorId>();
        this.updatedValueSetIds = new HashSet<ValueSetId>();
        this.dialobSessionUpdateHook = dialobSessionUpdateHook != null ? dialobSessionUpdateHook : DEFAULT_DIALOB_SESSION_EVAL_HOOKS;
    }

    private DialobSessionEvalContext(@Nonnull DialobSessionEvalContext parent, @Nonnull Scope scope) {
        this.parent = parent;
        this.scope = scope;
        this.functionRegistry = parent.functionRegistry;
        this.dialobSession = parent.dialobSession;
        this.updatesConsumer = parent.updatesConsumer;
        this.clock = parent.clock;
        this.activating = parent.activating;
        this.originalStates = parent.originalStates;
        this.pendingUpdates = parent.pendingUpdates;
        this.updatedItemIds = parent.updatedItemIds;
        this.updatedErrorIds = parent.updatedErrorIds;
        this.updatedValueSetIds = parent.updatedValueSetIds;
        this.dialobSessionUpdateHook = parent.dialobSessionUpdateHook;
    }

    public void applyAction(@Nonnull Command<?> action) {
        this.dialobSessionUpdateHook.hookAction(this.dialobSession, action, a -> this.dialobSession.applyUpdate(this, (Command<?>)a));
    }

    @Override
    public EvalContext withScope(Scope scope) {
        return new DialobSessionEvalContext(this, scope);
    }

    @Override
    public EvalContext getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public Optional<ItemState> getItemState(@Nonnull ItemId itemId) {
        if (IdUtils.QUESTIONNAIRE_ID.equals(itemId)) {
            return Optional.of(this.dialobSession.getRootItem());
        }
        return this.dialobSession.getItemState(this.scope(itemId, false));
    }

    @Override
    @Nonnull
    public Optional<ItemState> getOriginalItemState(@Nonnull ItemId itemId) {
        ItemId scopedId = this.scope(itemId, false);
        ItemState originalState = this.originalStates.getItemStates().get(scopedId);
        if (originalState != null) {
            return Optional.of(originalState);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemState> findPrototype(@Nonnull ItemId itemId) {
        return this.dialobSession.findPrototype(itemId);
    }

    @Override
    @Nonnull
    public Stream<ErrorState> findErrorPrototypes(@Nonnull ItemId itemId) {
        return this.dialobSession.findErrorPrototypes(itemId);
    }

    @Override
    @Nonnull
    public Optional<ValueSetState> getValueSetState(@Nonnull ValueSetId valueSetId) {
        return this.dialobSession.getValueSetState(valueSetId);
    }

    @Override
    public Object getItemValue(ItemId itemId) {
        return this.getItemState(this.scope(itemId, false)).map(ItemState::getValue).orElse(null);
    }

    @Nonnull
    private ItemId scope(@Nonnull ItemId itemId, boolean ignoreScopeItems) {
        if (this.scope != null) {
            return this.scope.mapTo(itemId, ignoreScopeItems);
        }
        return itemId;
    }

    @Override
    public void registerUpdate(ItemState newState, ItemState oldState) {
        if (newState != oldState) {
            ItemId id = oldState != null ? oldState.getId() : newState.getId();
            this.updatedItemIds.add(Objects.requireNonNull(id));
        }
    }

    @Override
    public void registerUpdate(ErrorState newState, ErrorState oldState) {
        if (newState != oldState) {
            ErrorId id = oldState != null ? oldState.getId() : newState.getId();
            this.updatedErrorIds.add(Objects.requireNonNull(id));
        }
    }

    @Override
    public void registerUpdate(@Nonnull ValueSetState newState, ValueSetState oldState) {
        if (newState != oldState) {
            ValueSetId id = oldState != null ? oldState.getId() : newState.getId();
            this.updatedValueSetIds.add(Objects.requireNonNull(id));
        }
    }

    @Override
    public void accept(@Nonnull EvalContext.UpdatedItemsVisitor visitor) {
        visitor.start();
        if (this.originalLanguage != null) {
            visitor.visitSession().ifPresent(sessionUpdatesVisitor -> {
                sessionUpdatesVisitor.visitLanguageChange(this.originalLanguage, this.dialobSession.getLanguage());
                sessionUpdatesVisitor.end();
            });
        }
        visitor.visitUpdatedItems().ifPresent(updatedItemStateVisitor -> {
            for (ItemId updateItemId : this.updatedItemIds) {
                ItemState originalState = this.originalStates.getItemStates().get(updateItemId);
                Optional<ItemState> itemState1 = this.dialobSession.getItemState(updateItemId);
                if (!itemState1.map(itemState -> itemState != originalState).orElse(originalState != null).booleanValue()) continue;
                updatedItemStateVisitor.visitUpdatedItemState(originalState, itemState1.orElse(null));
            }
            updatedItemStateVisitor.end();
        });
        visitor.visitUpdatedErrorStates().ifPresent(updatedErrorStateVisitor -> {
            for (ErrorId errorId : this.updatedErrorIds) {
                ErrorState originalState = this.originalStates.getErrorStates().get(errorId);
                Optional<ErrorState> itemState1 = this.dialobSession.getErrorState(errorId.getItemId(), errorId.getCode());
                if (!itemState1.map(itemState -> itemState != originalState).orElse(originalState != null).booleanValue()) continue;
                updatedErrorStateVisitor.visitUpdatedErrorState(originalState, itemState1.orElse(null));
            }
            updatedErrorStateVisitor.end();
        });
        visitor.visitUpdatedValueSets().ifPresent(updatedValueSetVisitor -> {
            for (ValueSetId valueSetId : this.updatedValueSetIds) {
                ValueSetState originalState = this.originalStates.getValueSetStates().get(valueSetId);
                Optional<ValueSetState> valueSetState = this.dialobSession.getValueSetState(valueSetId);
                if (!valueSetState.map(itemState -> itemState != originalState).orElse(originalState != null).booleanValue()) continue;
                updatedValueSetVisitor.visitUpdatedValueSet(originalState, valueSetState.orElse(null));
            }
            updatedValueSetVisitor.end();
        });
        visitor.visitAsyncFunctionCalls().ifPresent(asyncFunctionCallVisitor -> {
            this.pendingUpdates.values().forEach(asyncFunctionCallVisitor::visitAsyncFunctionCall);
            asyncFunctionCallVisitor.end();
        });
        if (this.didComplete) {
            visitor.visitCompleted();
        }
        visitor.end();
    }

    @Override
    public String getLanguage() {
        return this.dialobSession.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        if (this.originalLanguage == null) {
            this.originalLanguage = this.dialobSession.getLanguage();
        }
        this.dialobSession.setLanguage(language);
    }

    @Override
    @Nonnull
    public Consumer<Event> getEventsConsumer() {
        return this.updatesConsumer;
    }

    @Override
    public Collection<ErrorState> getErrorStates() {
        return this.dialobSession.getErrorStates().values();
    }

    @Override
    @Nonnull
    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    @Override
    @Nonnull
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @Nonnull
    public OutputFormatter getOutputFormatter() {
        return new OutputFormatter(this.dialobSession.getLanguage());
    }

    @Override
    public boolean isActivating() {
        return this.activating;
    }

    @Override
    public Optional<ItemState> findHoistingGroup(ItemId id) {
        return this.dialobSession.findHoistingGroup(id);
    }

    @Override
    public ItemId mapTo(ItemId itemId, boolean ignoreScopeItems) {
        return this.scope(itemId, ignoreScopeItems);
    }

    @Override
    public boolean complete() {
        if (!this.dialobSession.isCompleted() && this.dialobSession.complete()) {
            this.didComplete = true;
            return true;
        }
        return false;
    }

    @Override
    public String queueAsyncFunctionCall(AsyncFunctionCall asyncFunctionCall) {
        return asyncFunctionCall.getTargetId().map(itemId -> {
            this.pendingUpdates.put((ItemId)itemId, ((ImmutableAsyncFunctionCall)asyncFunctionCall).withId(this.dialobSession.generateUpdateId()));
            return IdUtils.toString(itemId);
        }).orElse(null);
    }
}

