/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.DialobSessionUpdateHook;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContext;
import io.dialob.session.engine.session.ActiveDialobSessionUpdater;
import io.dialob.session.engine.session.DialobSessionUpdater;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.DialobSession;
import java.time.Clock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class DialobSessionEvalContextFactory {
    private final FunctionRegistry functionRegistry;
    private final Clock clock;
    private final DialobSessionUpdateHook dialobSessionUpdateHook;

    public DialobSessionEvalContextFactory(FunctionRegistry functionRegistry, Clock clock, DialobSessionUpdateHook dialobSessionUpdateHook) {
        this.functionRegistry = functionRegistry;
        this.clock = clock;
        this.dialobSessionUpdateHook = dialobSessionUpdateHook;
    }

    @Nonnull
    public DialobSessionEvalContext createDialobSessionEvalContext(@Nonnull DialobSession dialobSession, @Nonnull Consumer<Event> updatesConsumer, boolean activating) {
        return new DialobSessionEvalContext(this.functionRegistry, dialobSession, updatesConsumer, this.clock, activating, this.dialobSessionUpdateHook);
    }

    public DialobSessionUpdater createSessionUpdater(@Nonnull DialobProgram dialobProgram, @Nonnull DialobSession dialobSession) {
        if (dialobSession.isCompleted()) {
            return DialobSessionUpdater.NOOP_UPDATER;
        }
        return new ActiveDialobSessionUpdater(this, dialobProgram, dialobSession);
    }
}

