/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.form.FormValidationError;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.spi.AliasesProvider;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProgramBuilder", generator="Immutables")
public final class ImmutableProgramBuilder {
    private ImmutableProgramBuilder() {
    }

    @CheckReturnValue
    @Generated(from="ProgramBuilder.CompilableExpression", generator="Immutables")
    @Immutable
    static final class CompilableExpression
    implements ProgramBuilder.CompilableExpression {
        private final ItemId itemId;
        private final String expression;
        private final AliasesProvider aliasesProvider;
        private final Consumer<Expression> expressionConsumer;
        private final FormValidationError.Type type;
        @Nullable
        private final Integer index;

        private CompilableExpression(ItemId itemId, String expression, AliasesProvider aliasesProvider, Consumer<Expression> expressionConsumer, FormValidationError.Type type, Optional<Integer> index) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.expression = Objects.requireNonNull(expression, "expression");
            this.aliasesProvider = Objects.requireNonNull(aliasesProvider, "aliasesProvider");
            this.expressionConsumer = Objects.requireNonNull(expressionConsumer, "expressionConsumer");
            this.type = Objects.requireNonNull(type, "type");
            this.index = index.orElse(null);
        }

        private CompilableExpression(CompilableExpression original, ItemId itemId, String expression, AliasesProvider aliasesProvider, Consumer<Expression> expressionConsumer, FormValidationError.Type type, @Nullable Integer index) {
            this.itemId = itemId;
            this.expression = expression;
            this.aliasesProvider = aliasesProvider;
            this.expressionConsumer = expressionConsumer;
            this.type = type;
            this.index = index;
        }

        @Override
        public ItemId getItemId() {
            return this.itemId;
        }

        @Override
        public String getExpression() {
            return this.expression;
        }

        @Override
        public AliasesProvider getAliasesProvider() {
            return this.aliasesProvider;
        }

        @Override
        public Consumer<Expression> getExpressionConsumer() {
            return this.expressionConsumer;
        }

        @Override
        public FormValidationError.Type getType() {
            return this.type;
        }

        @Override
        public Optional<Integer> getIndex() {
            return Optional.ofNullable(this.index);
        }

        public final CompilableExpression withItemId(ItemId value) {
            if (this.itemId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "itemId");
            return new CompilableExpression(this, newValue, this.expression, this.aliasesProvider, this.expressionConsumer, this.type, this.index);
        }

        public final CompilableExpression withExpression(String value) {
            String newValue = Objects.requireNonNull(value, "expression");
            if (this.expression.equals(newValue)) {
                return this;
            }
            return new CompilableExpression(this, this.itemId, newValue, this.aliasesProvider, this.expressionConsumer, this.type, this.index);
        }

        public final CompilableExpression withAliasesProvider(AliasesProvider value) {
            if (this.aliasesProvider == value) {
                return this;
            }
            AliasesProvider newValue = Objects.requireNonNull(value, "aliasesProvider");
            return new CompilableExpression(this, this.itemId, this.expression, newValue, this.expressionConsumer, this.type, this.index);
        }

        public final CompilableExpression withExpressionConsumer(Consumer<Expression> value) {
            if (this.expressionConsumer == value) {
                return this;
            }
            Consumer<Expression> newValue = Objects.requireNonNull(value, "expressionConsumer");
            return new CompilableExpression(this, this.itemId, this.expression, this.aliasesProvider, newValue, this.type, this.index);
        }

        public final CompilableExpression withType(FormValidationError.Type value) {
            if (this.type == value) {
                return this;
            }
            FormValidationError.Type newValue = Objects.requireNonNull(value, "type");
            if (this.type.equals((Object)newValue)) {
                return this;
            }
            return new CompilableExpression(this, this.itemId, this.expression, this.aliasesProvider, this.expressionConsumer, newValue, this.index);
        }

        public final CompilableExpression withIndex(int value) {
            Integer newValue = value;
            if (Objects.equals(this.index, newValue)) {
                return this;
            }
            return new CompilableExpression(this, this.itemId, this.expression, this.aliasesProvider, this.expressionConsumer, this.type, newValue);
        }

        public final CompilableExpression withIndex(Optional<Integer> optional) {
            Integer value = optional.orElse(null);
            if (Objects.equals(this.index, value)) {
                return this;
            }
            return new CompilableExpression(this, this.itemId, this.expression, this.aliasesProvider, this.expressionConsumer, this.type, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof CompilableExpression && this.equalTo((CompilableExpression)another);
        }

        private boolean equalTo(CompilableExpression another) {
            return this.itemId.equals(another.itemId) && this.expression.equals(another.expression) && this.aliasesProvider.equals(another.aliasesProvider) && this.expressionConsumer.equals(another.expressionConsumer) && this.type.equals((Object)another.type) && Objects.equals(this.index, another.index);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.itemId.hashCode();
            h += (h << 5) + this.expression.hashCode();
            h += (h << 5) + this.aliasesProvider.hashCode();
            h += (h << 5) + this.expressionConsumer.hashCode();
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + Objects.hashCode(this.index);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"CompilableExpression").omitNullValues().add("itemId", (Object)this.itemId).add("expression", (Object)this.expression).add("aliasesProvider", (Object)this.aliasesProvider).add("expressionConsumer", this.expressionConsumer).add("type", (Object)this.type).add("index", (Object)this.index).toString();
        }

        public static CompilableExpression of(ItemId itemId, String expression, AliasesProvider aliasesProvider, Consumer<Expression> expressionConsumer, FormValidationError.Type type, Optional<Integer> index) {
            return new CompilableExpression(itemId, expression, aliasesProvider, expressionConsumer, type, index);
        }

        public static CompilableExpression copyOf(ProgramBuilder.CompilableExpression instance) {
            if (instance instanceof CompilableExpression) {
                return (CompilableExpression)instance;
            }
            return CompilableExpression.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="ProgramBuilder.CompilableExpression", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ITEM_ID = 1L;
            private static final long INIT_BIT_EXPRESSION = 2L;
            private static final long INIT_BIT_ALIASES_PROVIDER = 4L;
            private static final long INIT_BIT_EXPRESSION_CONSUMER = 8L;
            private static final long INIT_BIT_TYPE = 16L;
            private long initBits = 31L;
            @Nullable
            private ItemId itemId;
            @Nullable
            private String expression;
            @Nullable
            private AliasesProvider aliasesProvider;
            @Nullable
            private Consumer<Expression> expressionConsumer;
            @Nullable
            private FormValidationError.Type type;
            @Nullable
            private Integer index;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(ProgramBuilder.CompilableExpression instance) {
                Objects.requireNonNull(instance, "instance");
                this.itemId(instance.getItemId());
                this.expression(instance.getExpression());
                this.aliasesProvider(instance.getAliasesProvider());
                this.expressionConsumer(instance.getExpressionConsumer());
                this.type(instance.getType());
                Optional<Integer> indexOptional = instance.getIndex();
                if (indexOptional.isPresent()) {
                    this.index(indexOptional);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder itemId(ItemId itemId) {
                this.itemId = Objects.requireNonNull(itemId, "itemId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder expression(String expression) {
                this.expression = Objects.requireNonNull(expression, "expression");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder aliasesProvider(AliasesProvider aliasesProvider) {
                this.aliasesProvider = Objects.requireNonNull(aliasesProvider, "aliasesProvider");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder expressionConsumer(Consumer<Expression> expressionConsumer) {
                this.expressionConsumer = Objects.requireNonNull(expressionConsumer, "expressionConsumer");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder type(FormValidationError.Type type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder index(int index) {
                this.index = index;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder index(Optional<Integer> index) {
                this.index = index.orElse(null);
                return this;
            }

            public CompilableExpression build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new CompilableExpression(null, this.itemId, this.expression, this.aliasesProvider, this.expressionConsumer, this.type, this.index);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("itemId");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("expression");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("aliasesProvider");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("expressionConsumer");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build CompilableExpression, some of required attributes are not set " + attributes;
            }
        }
    }
}

