/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.ddrl;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.api.ImmutableRuleExpressionCompilerError;
import io.dialob.rule.parser.api.RuleExpressionCompilerError;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.session.engine.program.ProgramBuilderException;
import io.dialob.session.engine.program.ddrl.UnknownValueTypeException;
import io.dialob.session.engine.program.expr.OperatorFactory;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.expr.arith.StringOperators;
import io.dialob.session.engine.program.expr.arith.TimeOperators;
import io.dialob.session.engine.session.model.IdUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DDRLExpressionCompiler {
    private final OperatorFactory operatorFactory;
    private final Map<NodeBase, String> asyncFunctionVariables;

    public DDRLExpressionCompiler(@Nonnull OperatorFactory operatorFactory) {
        this.operatorFactory = Objects.requireNonNull(operatorFactory);
        this.asyncFunctionVariables = Maps.newHashMap();
    }

    @Nonnull
    public <T> Optional<io.dialob.session.engine.program.model.Expression> compile(@Nonnull VariableFinder variableFinder, @Nonnull String expressionString, @Nonnull Consumer<RuleExpressionCompilerError> errorConsumer) {
        Expression expression = Expression.createExpression((VariableFinder)variableFinder, this.asyncFunctionVariables, (String)expressionString);
        expression.getErrors().forEach(errorConsumer::accept);
        NodeBase ast = expression.getAst();
        if (ast == null || !expression.getErrors().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.convertToImmutableExpression(ast));
        }
        catch (ProgramBuilderException e) {
            errorConsumer.accept((RuleExpressionCompilerError)ImmutableRuleExpressionCompilerError.builder().errorCode(e.getMessage()).span(e.getNode().getSpan()).args(e.getArgs().toArray()).build());
            return Optional.empty();
        }
    }

    @Nonnull
    private io.dialob.session.engine.program.model.Expression convertToImmutableExpression(@Nonnull NodeBase ast) {
        ASTVisitorBuilder visitorBuilder = new ASTVisitorBuilder();
        ast.accept((ASTVisitor)visitorBuilder);
        List<io.dialob.session.engine.program.model.Expression> expressions = visitorBuilder.getExpressions();
        assert (expressions.size() == 1);
        return expressions.get(0);
    }

    public Map<String, io.dialob.session.engine.program.model.Expression> getAsyncFunctionVariableExpressions() {
        return this.asyncFunctionVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, nodeBaseStringEntry -> this.convertToImmutableExpression((NodeBase)nodeBaseStringEntry.getKey())));
    }

    private class ASTVisitorBuilder
    implements ASTVisitor {
        private final List<io.dialob.session.engine.program.model.Expression> expressions = new ArrayList<io.dialob.session.engine.program.model.Expression>();
        private ASTVisitorBuilder builder;

        private ASTVisitorBuilder() {
        }

        @Nonnull
        public List<io.dialob.session.engine.program.model.Expression> getExpressions() {
            return this.expressions;
        }

        public ASTVisitor visitCallExpr(@Nonnull CallExprNode node) {
            this.builder = new ASTVisitorBuilder();
            return this.builder;
        }

        @Nonnull
        public NodeBase endCallExpr(@Nonnull CallExprNode node) {
            try {
                io.dialob.session.engine.program.model.Expression operator = DDRLExpressionCompiler.this.operatorFactory.createOperator(Objects.requireNonNull(node.getValueType()), node.getNodeOperator().getOperator(), this.builder.getExpressions());
                this.expressions.add(operator);
            }
            catch (ProgramBuilderException e) {
                e.setNode((NodeBase)node);
                throw e;
            }
            this.builder = null;
            return node;
        }

        @Nonnull
        public NodeBase visitConstExpr(@Nonnull ConstExprNode node) {
            this.expressions.add(ImmutableConstant.builder().valueType(Objects.requireNonNull(node.getValueType())).value(node.getAsValueType()).build());
            return node;
        }

        @Nonnull
        public NodeBase visitIdExpr(@Nonnull IdExprNode node) {
            switch (node.getId()) {
                case "today": {
                    this.expressions.add(TimeOperators.today());
                    break;
                }
                case "now": {
                    this.expressions.add(TimeOperators.now());
                    break;
                }
                case "language": {
                    this.expressions.add(StringOperators.languageOperator());
                    break;
                }
                default: {
                    if (node.getValueType() == null) {
                        throw new UnknownValueTypeException(node.getId());
                    }
                    this.expressions.add(Operators.var(IdUtils.toId(node.getScopeId(), node.getId()), node.getValueType()));
                }
            }
            return node;
        }
    }
}

