/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.Constant;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.ImmutableEqOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNeOperator;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.model.Expression;

public class BooleanOperators
implements Operators {
    public static final Constant<Boolean> FALSE = ImmutableConstant.builder().valueType(ValueType.BOOLEAN).value(Boolean.FALSE).build();
    public static final Constant<Boolean> TRUE = ImmutableConstant.builder().valueType(ValueType.BOOLEAN).value(Boolean.TRUE).build();

    @Override
    public InfixOperator<Boolean> eq(Expression lhs, Expression rhs) {
        return ImmutableEqOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> ne(Expression lhs, Expression rhs) {
        return ImmutableNeOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> le(Expression lhs, Expression rhs) {
        throw new RuntimeException("No relation operator between boolean types");
    }

    @Override
    public InfixOperator<Boolean> lt(Expression lhs, Expression rhs) {
        throw new RuntimeException("No relation operator between boolean types");
    }

    @Override
    public InfixOperator<Boolean> ge(Expression lhs, Expression rhs) {
        throw new RuntimeException("No relation operator between boolean types");
    }

    @Override
    public InfixOperator<Boolean> gt(Expression lhs, Expression rhs) {
        throw new RuntimeException("No relation operator between boolean types");
    }
}

