/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.ImmutableSet;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface CountArrayLengthOperator
extends Expression {
    public ItemId getItemId();

    @Override
    default public Integer eval(@Nonnull EvalContext evalContext) {
        return evalContext.getItemState(this.getItemId()).map(itemState -> {
            Object value = itemState.getValue();
            if (value == null) {
                return 0;
            }
            if (value.getClass().isArray()) {
                return ((Object[])value).length;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return ImmutableSet.of((Object)EventMatchers.whenValueUpdated(this.getItemId()));
    }
}

