/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.OutputFormatter;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface FormatOperator
extends Expression {
    @Value.Parameter
    public Expression getExpression();

    @Value.Parameter
    public String getFormat();

    @Override
    default public String eval(@Nonnull EvalContext context) {
        Object eval = this.getExpression().eval(context);
        if (eval == null) {
            return null;
        }
        OutputFormatter outputFormatter = new OutputFormatter(context.getLanguage());
        return outputFormatter.format(eval, this.getFormat());
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getExpression().getEvalRequiredConditions();
    }
}

