/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.expr.arith.FormatOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FormatOperator", generator="Immutables")
@Immutable
public final class ImmutableFormatOperator
implements FormatOperator {
    private final Expression expression;
    private final String format;

    private ImmutableFormatOperator(Expression expression, String format) {
        this.expression = Objects.requireNonNull(expression, "expression");
        this.format = Objects.requireNonNull(format, "format");
    }

    private ImmutableFormatOperator(ImmutableFormatOperator original, Expression expression, String format) {
        this.expression = expression;
        this.format = format;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public final ImmutableFormatOperator withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableFormatOperator(this, newValue, this.format);
    }

    public final ImmutableFormatOperator withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (this.format.equals(newValue)) {
            return this;
        }
        return new ImmutableFormatOperator(this, this.expression, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormatOperator && this.equalTo((ImmutableFormatOperator)another);
    }

    private boolean equalTo(ImmutableFormatOperator another) {
        return this.expression.equals(another.expression) && this.format.equals(another.format);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expression.hashCode();
        h += (h << 5) + this.format.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormatOperator").omitNullValues().add("expression", (Object)this.expression).add("format", (Object)this.format).toString();
    }

    public static ImmutableFormatOperator of(Expression expression, String format) {
        return new ImmutableFormatOperator(expression, format);
    }

    public static ImmutableFormatOperator copyOf(FormatOperator instance) {
        if (instance instanceof ImmutableFormatOperator) {
            return (ImmutableFormatOperator)instance;
        }
        return ImmutableFormatOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormatOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private static final long INIT_BIT_FORMAT = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression expression;
        @Nullable
        private String format;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FormatOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.expression(instance.getExpression());
            this.format(instance.getFormat());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFormatOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormatOperator(null, this.expression, this.format);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expression");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("format");
            }
            return "Cannot build FormatOperator, some of required attributes are not set " + attributes;
        }
    }
}

