/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.ImmutableSet;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

public interface InfixOperator<T>
extends Expression {
    @Value.Parameter
    public Expression getLhs();

    @Value.Parameter
    public Expression getRhs();

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        Set<EventMatcher> lset = this.getLhs().getEvalRequiredConditions();
        Set<EventMatcher> rset = this.getRhs().getEvalRequiredConditions();
        if (lset.isEmpty()) {
            return rset;
        }
        if (rset.isEmpty()) {
            return lset;
        }
        return ImmutableSet.builder().addAll(lset).addAll(rset).build();
    }
}

