/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.ConstantValue;
import io.dialob.session.engine.program.model.Value;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConstantValue", generator="Immutables")
@Immutable
public final class ImmutableConstantValue<T>
implements ConstantValue<T> {
    private final T value;
    @Nullable
    private final ValueType valueType;

    private ImmutableConstantValue(T value, @Nullable ValueType valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public ValueType getValueType() {
        return this.valueType;
    }

    public final ImmutableConstantValue<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableConstantValue<T>(newValue, this.valueType);
    }

    public final ImmutableConstantValue<T> withValueType(@Nullable ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableConstantValue<T>(this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConstantValue && this.equalTo((ImmutableConstantValue)another);
    }

    private boolean equalTo(ImmutableConstantValue<?> another) {
        return this.value.equals(another.value) && Objects.equals(this.valueType, another.valueType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.valueType);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConstantValue").omitNullValues().add("value", this.value).add("valueType", (Object)this.valueType).toString();
    }

    public static <T> ImmutableConstantValue<T> copyOf(ConstantValue<T> instance) {
        if (instance instanceof ImmutableConstantValue) {
            return (ImmutableConstantValue)instance;
        }
        return ImmutableConstantValue.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ConstantValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private T value;
        @Nullable
        private ValueType valueType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Value<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ConstantValue<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ValueType valueTypeValue;
            Value instance;
            long bits = 0L;
            if (object instanceof Value) {
                instance = (Value)object;
                if ((bits & 1L) == 0L) {
                    valueTypeValue = instance.getValueType();
                    if (valueTypeValue != null) {
                        this.valueType(valueTypeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ConstantValue) {
                instance = (ConstantValue)object;
                this.value(instance.getValue());
                if ((bits & 1L) == 0L) {
                    valueTypeValue = instance.getValueType();
                    if (valueTypeValue != null) {
                        this.valueType(valueTypeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> valueType(@Nullable ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public ImmutableConstantValue<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConstantValue<T>(this.value, this.valueType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ConstantValue, some of required attributes are not set " + attributes;
        }
    }
}

