/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.Program;
import io.dialob.session.engine.program.model.ValueSet;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Program", generator="Immutables")
@Immutable
public final class ImmutableProgram
implements Program {
    private final String id;
    private final Item rootItem;
    private final ImmutableList<Item> items;
    private final ImmutableList<ValueSet> valueSets;

    private ImmutableProgram(String id, Item rootItem, ImmutableList<Item> items, ImmutableList<ValueSet> valueSets) {
        this.id = id;
        this.rootItem = rootItem;
        this.items = items;
        this.valueSets = valueSets;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Item getRootItem() {
        return this.rootItem;
    }

    public ImmutableList<Item> getItems() {
        return this.items;
    }

    public ImmutableList<ValueSet> getValueSets() {
        return this.valueSets;
    }

    public final ImmutableProgram withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableProgram(newValue, this.rootItem, this.items, this.valueSets);
    }

    public final ImmutableProgram withRootItem(Item value) {
        if (this.rootItem == value) {
            return this;
        }
        Item newValue = Objects.requireNonNull(value, "rootItem");
        return new ImmutableProgram(this.id, newValue, this.items, this.valueSets);
    }

    public final ImmutableProgram withItems(Item ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableProgram(this.id, this.rootItem, (ImmutableList<Item>)newValue, this.valueSets);
    }

    public final ImmutableProgram withItems(Iterable<? extends Item> elements) {
        if (this.items == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableProgram(this.id, this.rootItem, (ImmutableList<Item>)newValue, this.valueSets);
    }

    public final ImmutableProgram withValueSets(ValueSet ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableProgram(this.id, this.rootItem, this.items, (ImmutableList<ValueSet>)newValue);
    }

    public final ImmutableProgram withValueSets(Iterable<? extends ValueSet> elements) {
        if (this.valueSets == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableProgram(this.id, this.rootItem, this.items, (ImmutableList<ValueSet>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgram && this.equalTo((ImmutableProgram)another);
    }

    private boolean equalTo(ImmutableProgram another) {
        return this.id.equals(another.id) && this.rootItem.equals(another.rootItem) && this.items.equals(another.items) && this.valueSets.equals(another.valueSets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rootItem.hashCode();
        h += (h << 5) + this.items.hashCode();
        h += (h << 5) + this.valueSets.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Program").omitNullValues().add("id", (Object)this.id).add("rootItem", (Object)this.rootItem).add("items", this.items).add("valueSets", this.valueSets).toString();
    }

    public static ImmutableProgram copyOf(Program instance) {
        if (instance instanceof ImmutableProgram) {
            return (ImmutableProgram)instance;
        }
        return ImmutableProgram.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Program", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ROOT_ITEM = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private Item rootItem;
        private ImmutableList.Builder<Item> items = ImmutableList.builder();
        private ImmutableList.Builder<ValueSet> valueSets = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Program instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rootItem(instance.getRootItem());
            this.addAllItems(instance.getItems());
            this.addAllValueSets(instance.getValueSets());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rootItem(Item rootItem) {
            this.rootItem = Objects.requireNonNull(rootItem, "rootItem");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Item element) {
            this.items.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Item ... elements) {
            this.items.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder items(Iterable<? extends Item> elements) {
            this.items = ImmutableList.builder();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends Item> elements) {
            this.items.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValueSets(ValueSet element) {
            this.valueSets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValueSets(ValueSet ... elements) {
            this.valueSets.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSets(Iterable<? extends ValueSet> elements) {
            this.valueSets = ImmutableList.builder();
            return this.addAllValueSets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValueSets(Iterable<? extends ValueSet> elements) {
            this.valueSets.addAll(elements);
            return this;
        }

        public ImmutableProgram build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProgram(this.id, this.rootItem, (ImmutableList<Item>)this.items.build(), (ImmutableList<ValueSet>)this.valueSets.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootItem");
            }
            return "Cannot build Program, some of required attributes are not set " + attributes;
        }
    }
}

