/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session;

import io.dialob.api.proto.Action;
import io.dialob.session.engine.DebugUtil;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContext;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.DialobSessionUpdater;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.CommandFactory;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDialobSessionUpdater
implements DialobSessionUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDialobSessionUpdater.class);
    private final DialobSessionEvalContextFactory sessionContextFactory;
    private final DialobSession dialobSession;
    private final DialobProgram dialobProgram;
    private final Set<Command<?>> updated = new HashSet();
    protected final List<Command<?>> evalQueue = new LinkedList();

    public ActiveDialobSessionUpdater(@Nonnull DialobSessionEvalContextFactory sessionContextFactory, @Nonnull DialobProgram dialobProgram, @Nonnull DialobSession dialobSession) {
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory);
        this.dialobProgram = Objects.requireNonNull(dialobProgram);
        this.dialobSession = Objects.requireNonNull(dialobSession);
    }

    @Override
    public Consumer<EvalContext.UpdatedItemsVisitor> dispatchActions(@Nonnull Iterable<Action> actions) {
        return this.dispatchActions(actions, false);
    }

    @Override
    public Consumer<EvalContext.UpdatedItemsVisitor> dispatchActions(@Nonnull Iterable<Action> actions, boolean activating) {
        DialobSessionEvalContext evalContext = this.sessionContextFactory.createDialobSessionEvalContext(this.dialobSession, this::queueUpdate, activating);
        this.applyUpdates(actions);
        while (!this.evalQueue.isEmpty()) {
            ListIterator<Command<?>> iterator = this.evalQueue.listIterator();
            Command<?> command = iterator.next();
            iterator.remove();
            this.matchPartialCommands(command).forEach(action -> {
                this.updated.add((Command<?>)action);
                evalContext.applyAction((Command<?>)action);
            });
        }
        this.updated.clear();
        LOGGER.debug("Update completed.");
        return evalContext::accept;
    }

    protected void applyUpdates(@Nonnull Iterable<Action> actions) {
        actions.forEach(action -> {
            ItemId itemId = IdUtils.toIdNullable(action.getId());
            switch (action.getType()) {
                case ANSWER: {
                    this.queueCommand(CommandFactory.setAnswer(Objects.requireNonNull(itemId), action.getAnswer()));
                    break;
                }
                case SET_VALUE: {
                    this.queueCommand(CommandFactory.setVariableValue(Objects.requireNonNull(itemId), action.getValue()));
                    break;
                }
                case SET_FAILED: {
                    this.queueCommand(CommandFactory.setVariableFailed(Objects.requireNonNull(itemId)));
                    break;
                }
                case NEXT: {
                    this.queueCommand(CommandFactory.nextPage());
                    break;
                }
                case PREVIOUS: {
                    this.queueCommand(CommandFactory.prevPage());
                    break;
                }
                case GOTO: {
                    this.queueCommand(CommandFactory.gotoPage(Objects.requireNonNull(itemId)));
                    break;
                }
                case COMPLETE: {
                    this.queueCommand(CommandFactory.complete());
                    break;
                }
                case ADD_ROW: {
                    this.queueCommand(CommandFactory.addRow(Objects.requireNonNull(itemId)));
                    break;
                }
                case DELETE_ROW: {
                    this.queueCommand(CommandFactory.deleteRow(Objects.requireNonNull(itemId)));
                    break;
                }
                case SET_LOCALE: {
                    if (!(action.getValue() instanceof String)) break;
                    this.queueCommand(CommandFactory.setLocale((String)action.getValue()));
                    break;
                }
                default: {
                    LOGGER.debug("Action \"{}\" ignored.", action);
                }
            }
        });
    }

    private void queueUpdate(@Nonnull Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" -> event({})", (Object)event);
        }
        this.dialobProgram.findDependencies(event).forEach(this::queueCommand);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  = {}", (Object)StringUtils.join((Object[])this.evalQueue.stream().map(DebugUtil::commandToString).toArray(), (String)" ,"));
        }
    }

    private Stream<Command<?>> matchPartialCommands(Command<?> command) {
        UpdateCommand updateCommand;
        Object targetId;
        if (command instanceof UpdateCommand && (targetId = (updateCommand = (UpdateCommand)command).getTargetId()).isPartial()) {
            return this.dialobSession.findMatchingItemIds((ItemId)targetId).map(updateCommand::withTargetId);
        }
        return Stream.of(command);
    }

    protected void queueCommand(@Nonnull Command<?> updateCommand) {
        Set<Command<?>> mustBeBefore = this.dialobProgram.getCommandsToCommands(updateCommand);
        if (mustBeBefore.isEmpty()) {
            this.evalQueue.add(updateCommand);
            return;
        }
        ListIterator<Command<?>> i = this.evalQueue.listIterator();
        while (i.hasNext()) {
            Command<?> command = i.next();
            if (updateCommand.equals(command)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  - skip {} (on queue already)", (Object)DebugUtil.commandToString(updateCommand));
                }
                return;
            }
            if (!mustBeBefore.contains(command)) continue;
            i.previous();
            break;
        }
        i.add(updateCommand);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  + queued {}", (Object)DebugUtil.commandToString(updateCommand));
        }
        if (LOGGER.isDebugEnabled() && this.updated.contains(updateCommand)) {
            LOGGER.debug("Target {} already executed. Cyclic dependency?", (Object)DebugUtil.commandToString(updateCommand));
        }
    }
}

