/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.model.ImmutableItemStates;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface CreateRowGroupFromPrototypeCommand
extends SessionUpdateCommand {
    @Value.Parameter
    public ItemId getItemPrototypeId();

    @Override
    @Nonnull
    default public ItemStates update(@Nonnull EvalContext context, @Nonnull ItemStates itemStates) {
        return this.getItemPrototypeId().getParent().flatMap(groupId -> {
            HashSet currentItems = Sets.newHashSet(itemStates.getItemStates().get(groupId).getItems());
            Set originalItems = context.getOriginalItemState((ItemId)groupId).map(state -> Sets.newHashSet(state.getItems())).orElse((Set)ImmutableSet.of());
            Sets.SetView newItems = Sets.difference((Set)currentItems, (Set)originalItems);
            Sets.SetView removedItems = Sets.difference((Set)originalItems, (Set)currentItems);
            return context.findPrototype(this.getItemPrototypeId()).map(prototypeState -> ImmutableItemStates.builder().from(itemStates).itemStates(itemStates.getItemStates().values().stream().filter(item -> !removedItems.contains((Object)item.getId())).collect(Collectors.toMap(itemState -> Objects.requireNonNull(itemState.getId()), item -> item))).putAllItemStates(newItems.stream().map(prototypeState::withId).collect(Collectors.toMap(ItemState::getId, item -> item))).build());
        }).orElse(itemStates);
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEventMatchers() {
        return (Set)this.getItemPrototypeId().getParent().map(groupId -> ImmutableSet.of((Object)EventMatchers.whenItemsChanged(groupId))).orElse(ImmutableSet.of());
    }
}

