/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.ImmutableSet;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

public interface ErrorUpdateCommand
extends UpdateCommand<ErrorId, ErrorState> {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @Nonnull
    default public Set<EventMatcher> getEventMatchers() {
        Set<EventMatcher> eventMatchers = this.getExpression().getEvalRequiredConditions();
        if (((ErrorId)this.getTargetId()).isPartial()) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(eventMatchers);
            builder.add((Object)EventMatchers.whenItemAdded(((ErrorId)this.getTargetId()).getItemId()));
            ErrorUpdateCommand.findConcreteItem(this.getTargetId()).map(EventMatchers::whenItemsChanged).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            return builder.build();
        }
        return eventMatchers;
    }

    public static Optional<ItemId> findConcreteItem(ItemId id) {
        if (id.isPartial()) {
            return id.getParent().flatMap(ErrorUpdateCommand::findConcreteItem);
        }
        return Optional.of(id);
    }
}

