/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.Complete;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Complete", generator="Immutables")
@Immutable
public final class ImmutableComplete
implements Complete {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;

    private ImmutableComplete(Iterable<? extends Trigger<ItemState>> triggers) {
        this.triggers = ImmutableList.copyOf(triggers);
        this.targetId = Objects.requireNonNull(Complete.super.getTargetId(), "targetId");
    }

    private ImmutableComplete(Builder builder) {
        this.triggers = builder.triggers.build();
        this.targetId = builder.targetId != null ? builder.targetId : Objects.requireNonNull(Complete.super.getTargetId(), "targetId");
    }

    private ImmutableComplete(ImmutableList<Trigger<ItemState>> triggers, ItemId targetId) {
        this.triggers = triggers;
        this.targetId = targetId;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @SafeVarargs
    public final ImmutableComplete withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableComplete((ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableComplete withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableComplete((ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableComplete withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableComplete(this.triggers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComplete && this.equalTo((ImmutableComplete)another);
    }

    private boolean equalTo(ImmutableComplete another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Complete").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).toString();
    }

    public static ImmutableComplete of(List<Trigger<ItemState>> triggers) {
        return ImmutableComplete.of(triggers);
    }

    public static ImmutableComplete of(Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableComplete(triggers);
    }

    public static ImmutableComplete copyOf(Complete instance) {
        if (instance instanceof ImmutableComplete) {
            return (ImmutableComplete)instance;
        }
        return ImmutableComplete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Complete", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Complete instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId(instance.getTargetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            return this;
        }

        public ImmutableComplete build() {
            return new ImmutableComplete(this);
        }
    }
}

