/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.DeleteRow;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteRow", generator="Immutables")
@Immutable
public final class ImmutableDeleteRow
implements DeleteRow {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    private final ItemId toBeRemoved;

    private ImmutableDeleteRow(ItemId targetId, ItemId toBeRemoved, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.toBeRemoved = Objects.requireNonNull(toBeRemoved, "toBeRemoved");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableDeleteRow(ImmutableDeleteRow original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, ItemId toBeRemoved) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.toBeRemoved = toBeRemoved;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    public ItemId getToBeRemoved() {
        return this.toBeRemoved;
    }

    @SafeVarargs
    public final ImmutableDeleteRow withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDeleteRow(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.toBeRemoved);
    }

    public final ImmutableDeleteRow withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDeleteRow(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.toBeRemoved);
    }

    public final ImmutableDeleteRow withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableDeleteRow(this, this.triggers, newValue, this.toBeRemoved);
    }

    public final ImmutableDeleteRow withToBeRemoved(ItemId value) {
        if (this.toBeRemoved == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "toBeRemoved");
        return new ImmutableDeleteRow(this, this.triggers, this.targetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteRow && this.equalTo((ImmutableDeleteRow)another);
    }

    private boolean equalTo(ImmutableDeleteRow another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.toBeRemoved.equals(another.toBeRemoved);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.toBeRemoved.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeleteRow").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("toBeRemoved", (Object)this.toBeRemoved).toString();
    }

    public static ImmutableDeleteRow of(ItemId targetId, ItemId toBeRemoved, List<Trigger<ItemState>> triggers) {
        return ImmutableDeleteRow.of(targetId, toBeRemoved, triggers);
    }

    public static ImmutableDeleteRow of(ItemId targetId, ItemId toBeRemoved, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableDeleteRow(targetId, toBeRemoved, triggers);
    }

    public static ImmutableDeleteRow copyOf(DeleteRow instance) {
        if (instance instanceof ImmutableDeleteRow) {
            return (ImmutableDeleteRow)instance;
        }
        return ImmutableDeleteRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private static final long INIT_BIT_TO_BE_REMOVED = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;
        @Nullable
        private ItemId toBeRemoved;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            this.toBeRemoved(instance.getToBeRemoved());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toBeRemoved(ItemId toBeRemoved) {
            this.toBeRemoved = Objects.requireNonNull(toBeRemoved, "toBeRemoved");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteRow(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId, this.toBeRemoved);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("toBeRemoved");
            }
            return "Cannot build DeleteRow, some of required attributes are not set " + attributes;
        }
    }
}

