/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.AbstractPageCommand;
import io.dialob.session.engine.session.command.GotoPage;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GotoPage", generator="Immutables")
@Immutable
public final class ImmutableGotoPage
implements GotoPage {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    private final ItemId page;

    private ImmutableGotoPage(ItemId page, Iterable<? extends Trigger<ItemState>> triggers) {
        this.page = Objects.requireNonNull(page, "page");
        this.triggers = ImmutableList.copyOf(triggers);
        this.targetId = Objects.requireNonNull(GotoPage.super.getTargetId(), "targetId");
    }

    private ImmutableGotoPage(Builder builder) {
        this.triggers = builder.triggers.build();
        this.page = builder.page;
        this.targetId = builder.targetId != null ? builder.targetId : Objects.requireNonNull(GotoPage.super.getTargetId(), "targetId");
    }

    private ImmutableGotoPage(ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, ItemId page) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.page = page;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    public ItemId getPage() {
        return this.page;
    }

    @SafeVarargs
    public final ImmutableGotoPage withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGotoPage((ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.page);
    }

    public final ImmutableGotoPage withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGotoPage((ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.page);
    }

    public final ImmutableGotoPage withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableGotoPage(this.triggers, newValue, this.page);
    }

    public final ImmutableGotoPage withPage(ItemId value) {
        if (this.page == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "page");
        return new ImmutableGotoPage(this.triggers, this.targetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGotoPage && this.equalTo((ImmutableGotoPage)another);
    }

    private boolean equalTo(ImmutableGotoPage another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.page.equals(another.page);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.page.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GotoPage").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("page", (Object)this.page).toString();
    }

    public static ImmutableGotoPage of(ItemId page, List<Trigger<ItemState>> triggers) {
        return ImmutableGotoPage.of(page, triggers);
    }

    public static ImmutableGotoPage of(ItemId page, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableGotoPage(page, triggers);
    }

    public static ImmutableGotoPage copyOf(GotoPage instance) {
        if (instance instanceof ImmutableGotoPage) {
            return (ImmutableGotoPage)instance;
        }
        return ImmutableGotoPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GotoPage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAGE = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;
        @Nullable
        private ItemId page;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GotoPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractPageCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractPageCommand instance;
            long bits = 0L;
            if (object instanceof GotoPage) {
                instance = (GotoPage)object;
                if ((bits & 1L) == 0L) {
                    this.targetId(instance.getTargetId());
                    bits |= 1L;
                }
                this.addAllTriggers(instance.getTriggers());
                this.page(instance.getPage());
            }
            if (object instanceof AbstractPageCommand) {
                instance = (AbstractPageCommand)object;
                if ((bits & 1L) == 0L) {
                    this.targetId(instance.getTargetId());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder page(ItemId page) {
            this.page = Objects.requireNonNull(page, "page");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGotoPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGotoPage(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("page");
            }
            return "Cannot build GotoPage, some of required attributes are not set " + attributes;
        }
    }
}

