/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.NopCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NopCommand", generator="Immutables")
@Immutable
public final class ImmutableNopCommand
implements NopCommand {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;

    private ImmutableNopCommand(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableNopCommand(ImmutableNopCommand original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId) {
        this.triggers = triggers;
        this.targetId = targetId;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @SafeVarargs
    public final ImmutableNopCommand withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNopCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableNopCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNopCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableNopCommand withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableNopCommand(this, this.triggers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNopCommand && this.equalTo((ImmutableNopCommand)another);
    }

    private boolean equalTo(ImmutableNopCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NopCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).toString();
    }

    public static ImmutableNopCommand of(ItemId targetId, List<Trigger<ItemState>> triggers) {
        return ImmutableNopCommand.of(targetId, triggers);
    }

    public static ImmutableNopCommand of(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableNopCommand(targetId, triggers);
    }

    public static ImmutableNopCommand copyOf(NopCommand instance) {
        if (instance instanceof ImmutableNopCommand) {
            return (ImmutableNopCommand)instance;
        }
        return ImmutableNopCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NopCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NopCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNopCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNopCommand(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build NopCommand, some of required attributes are not set " + attributes;
        }
    }
}

